/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.simantics.acorn.ClusterManager;
import org.simantics.acorn.GraphClientImpl2;
import org.simantics.acorn.exception.AcornAccessVerificationException;
import org.simantics.acorn.exception.IllegalAcornStateException;
import org.simantics.acorn.lru.ClusterStreamChunk;
import org.simantics.acorn.lru.ClusterUpdateOperation;
import org.simantics.db.service.ClusterUID;
import org.simantics.utils.logging.TimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainProgram
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainProgram.class);
    private static final int CLUSTER_THREADS = 4;
    private static final int CHUNK_CACHE_SIZE = 100;
    private final GraphClientImpl2 client;
    private final ClusterManager clusters;
    private final ExecutorService[] clusterUpdateThreads;
    private final List<ClusterUpdateOperation>[] updateSchedules;
    private int residentOperationBytes = 0;
    private long currentChangeSetId = -1L;
    private int nextChunkId = 0;
    private boolean alive = true;
    private Semaphore deathBarrier = new Semaphore(0);
    final Semaphore mutex = new Semaphore(1);
    final LinkedList<ClusterStreamChunk> operations = new LinkedList();
    private static Comparator<ClusterUID> clusterComparator = new Comparator<ClusterUID>(){

        @Override
        public int compare(ClusterUID o1, ClusterUID o2) {
            return Long.compare(o1.second, o2.second);
        }
    };

    public MainProgram(GraphClientImpl2 client, ClusterManager clusters) {
        this.client = client;
        this.clusters = clusters;
        this.clusterUpdateThreads = new ExecutorService[4];
        this.updateSchedules = new ArrayList[4];
        int i = 0;
        while (i < this.clusterUpdateThreads.length) {
            this.clusterUpdateThreads[i] = Executors.newSingleThreadExecutor(new ClusterThreadFactory("Cluster Updater " + (i + 1), false));
            this.updateSchedules[i] = new ArrayList<ClusterUpdateOperation>();
            ++i;
        }
    }

    public void startTransaction(long id) {
        this.currentChangeSetId = id;
        this.nextChunkId = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                this.mutex.acquire();
                while (this.alive) {
                    block37: {
                        TreeMap<ClusterUID, ArrayList<ClusterUpdateOperation>> updates = new TreeMap<ClusterUID, ArrayList<ClusterUpdateOperation>>(clusterComparator);
                        MainProgram mainProgram = this;
                        synchronized (mainProgram) {
                            while (!this.operations.isEmpty() && updates.size() < 100) {
                                ClusterStreamChunk chunk = this.operations.pollFirst();
                                int i = chunk.nextToProcess;
                                while (i < chunk.operations.size()) {
                                    ClusterUpdateOperation o = chunk.operations.get(i);
                                    ClusterUID uid = o.uid;
                                    ArrayList<ClusterUpdateOperation> ops = (ArrayList<ClusterUpdateOperation>)updates.get(uid);
                                    if (ops == null) {
                                        ops = new ArrayList<ClusterUpdateOperation>();
                                        updates.put(uid, ops);
                                    }
                                    ops.add(o);
                                    ++i;
                                }
                                chunk.nextToProcess = chunk.operations.size();
                                if (chunk.isCommitted()) continue;
                                assert (this.operations.isEmpty());
                                this.operations.add(chunk);
                                break;
                            }
                            if (updates.isEmpty()) {
                                try {
                                    long start = System.nanoTime();
                                    this.mutex.release();
                                    this.wait(5000L);
                                    this.mutex.acquire();
                                    if (!this.alive) {
                                        break;
                                    }
                                    long duration = System.nanoTime() - start;
                                    if (duration > 4000000000L && this.operations.isEmpty()) {
                                        boolean written = this.clusters.csLRU.swapForced();
                                        while (written) {
                                            if (!updates.isEmpty()) break;
                                            written = this.clusters.csLRU.swapForced();
                                        }
                                        written = this.clusters.streamLRU.swapForced();
                                        while (written) {
                                            if (!updates.isEmpty()) break;
                                            written = this.clusters.streamLRU.swapForced();
                                        }
                                        written = this.clusters.fileLRU.swapForced();
                                        while (written) {
                                            if (!updates.isEmpty()) break;
                                            written = this.clusters.fileLRU.swapForced();
                                        }
                                        written = this.clusters.clusterLRU.swapForced();
                                        while (written) {
                                            if (!updates.isEmpty()) break;
                                            written = this.clusters.clusterLRU.swapForced();
                                        }
                                        this.client.tryMakeSnapshot();
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        int i = 0;
                        while (i < 4) {
                            this.updateSchedules[i].clear();
                            ++i;
                        }
                        final Semaphore s = new Semaphore(0);
                        for (Map.Entry entry : updates.entrySet()) {
                            ClusterUID key = entry.getKey();
                            int hash = key.hashCode() & this.clusterUpdateThreads.length - 1;
                            this.updateSchedules[hash].addAll((Collection)entry.getValue());
                        }
                        int acquireAmount = 0;
                        int i2 = 0;
                        while (i2 < 4) {
                            final List<ClusterUpdateOperation> ops = this.updateSchedules[i2];
                            if (!ops.isEmpty()) {
                                ++acquireAmount;
                                this.clusterUpdateThreads[i2].submit(new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        try {
                                            for (ClusterUpdateOperation op : ops) {
                                                op.run();
                                            }
                                        }
                                        finally {
                                            s.release();
                                        }
                                        return null;
                                    }
                                });
                            }
                            ++i2;
                        }
                        s.acquire(acquireAmount);
                        this.clusters.streamLRU.acquireMutex();
                        try {
                            try {
                                this.swapChunks();
                            }
                            catch (AcornAccessVerificationException | IllegalAcornStateException e) {
                                e.printStackTrace();
                                this.clusters.streamLRU.releaseMutex();
                                break block37;
                            }
                        }
                        catch (Throwable throwable) {
                            this.clusters.streamLRU.releaseMutex();
                            throw throwable;
                        }
                        this.clusters.streamLRU.releaseMutex();
                    }
                    this.clusters.csLRU.acquireMutex();
                    try {
                        try {
                            this.swapCS();
                        }
                        catch (Throwable t) {
                            throw new IllegalAcornStateException(t);
                        }
                    }
                    finally {
                        this.clusters.csLRU.releaseMutex();
                    }
                    TimeLogger.log((String)"Performed updates");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.deathBarrier.release();
            }
        }
        finally {
            this.deathBarrier.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Exception runIdle(MainProgramRunnable runnable) {
        try {
            long startTime = System.currentTimeMillis();
            while (true) {
                boolean hasMutex = false;
                try {
                    MainProgram mainProgram = this;
                    synchronized (mainProgram) {
                        hasMutex = this.mutex.tryAcquire();
                        if (hasMutex && this.operations.isEmpty()) {
                            runnable.run();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 2, 8, 15] lbl12 : MonitorExitStatement: MONITOREXIT : var5_5
                            if (!hasMutex) return null;
                            this.mutex.release();
                            return null;
                        }
                    }
                }
                catch (Exception e) {
                    Exception exception = e;
                    if (hasMutex) {
                        this.mutex.release();
                    }
                    runnable.done();
                    return exception;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                long endTime = System.currentTimeMillis();
                if (endTime - startTime <= 100L) continue;
                startTime = endTime;
                LOGGER.info("MainProgram.runIdle() retry mutex acquire!");
            }
        }
        finally {
            runnable.done();
        }
    }

    private void swapChunks() throws AcornAccessVerificationException, IllegalAcornStateException {
        while (this.clusters.streamLRU.swap(Long.MAX_VALUE, 100)) {
        }
    }

    private void swapCS() throws AcornAccessVerificationException, IllegalAcornStateException {
        while (this.clusters.csLRU.swap(Long.MAX_VALUE, 100)) {
        }
    }

    public synchronized void committed() {
        ClusterStreamChunk last;
        ClusterStreamChunk clusterStreamChunk = last = this.operations.isEmpty() ? null : this.operations.getLast();
        if (!this.alive) {
            LOGGER.error("Trying to commit operation after MainProgram is closed! Operation is " + last);
        }
        if (last != null) {
            last.commit();
            this.notifyAll();
        }
    }

    public synchronized void schedule(ClusterUpdateOperation operation) throws IllegalAcornStateException {
        if (!this.alive) {
            LOGGER.error("Trying to schedule operation after MainProgram is closed! Operation is " + operation);
        }
        this.clusters.streamLRU.acquireMutex();
        try {
            try {
                ClusterStreamChunk last;
                ClusterStreamChunk clusterStreamChunk = last = this.operations.isEmpty() ? null : this.operations.getLast();
                if (last == null || last.isCommitted()) {
                    String id = this.currentChangeSetId + "-" + this.nextChunkId++;
                    last = new ClusterStreamChunk(this.clusters, this.clusters.streamLRU, id);
                    this.operations.add(last);
                }
                String chunkId = (String)last.getKey();
                int chunkOffset = last.operations.size();
                operation.scheduled(String.valueOf(chunkId) + "." + chunkOffset);
                last.addOperation(operation);
                this.swapChunks();
                this.notifyAll();
            }
            catch (IllegalAcornStateException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IllegalAcornStateException(t);
            }
        }
        finally {
            this.clusters.streamLRU.releaseMutex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.alive = false;
        MainProgram mainProgram = this;
        synchronized (mainProgram) {
            this.notifyAll();
        }
        try {
            this.deathBarrier.acquire();
        }
        catch (InterruptedException interruptedException) {}
        ExecutorService[] executorServiceArray = this.clusterUpdateThreads;
        int n = this.clusterUpdateThreads.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutorService executor = executorServiceArray[n2];
            executor.shutdown();
            ++n2;
        }
        int i = 0;
        while (i < this.clusterUpdateThreads.length) {
            try {
                ExecutorService executor = this.clusterUpdateThreads[i];
                executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
                this.clusterUpdateThreads[i] = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    static class ClusterThreadFactory
    implements ThreadFactory {
        final String name;
        final boolean daemon;

        public ClusterThreadFactory(String name, boolean daemon) {
            this.name = name;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.name);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }

    static interface MainProgramRunnable {
        public void run() throws Exception;

        public void done();
    }
}

