/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import fi.vtt.simantics.procore.internal.SessionImplDb;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.acorn.AcornDatabaseManager;
import org.simantics.acorn.GraphClientImpl2;
import org.simantics.db.Database;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.SessionErrorHandler;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.event.SessionEvent;
import org.simantics.db.event.SessionListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.ListenerList;

public class AcornSessionManagerImpl
implements SessionManager {
    private static AcornSessionManagerImpl INSTANCE;
    private ConcurrentHashMap<SessionImplDb, Database.Session> sessionMap = new ConcurrentHashMap();
    private ListenerList<SessionListener> sessionListeners = new ListenerList(SessionListener.class);
    private SessionErrorHandler errorHandler;
    private Database database;

    private AcornSessionManagerImpl() {
    }

    void finish() {
        this.sessionMap = null;
        this.sessionListeners = null;
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add((Object)listener);
    }

    public Session createSession(SessionReference sessionReference, UserAuthenticationAgent authAgent) throws DatabaseException {
        SessionImplDb sessionImpl = new SessionImplDb((SessionManager)this, authAgent);
        boolean ok = false;
        try {
            try {
                Path dbFolder = sessionReference.getServerReference().getDBFolder();
                this.database = AcornDatabaseManager.getDatabase(dbFolder);
                Database.Session dbSession = this.database.newSession((ServiceLocator)sessionImpl);
                sessionImpl.connect(sessionReference, dbSession);
                this.sessionMap.put(sessionImpl, dbSession);
                this.fireSessionOpened((SessionImplSocket)sessionImpl);
                ok = true;
            }
            catch (Throwable e) {
                Logger.defaultLogError((String)"Connection failed. See exception for details.", (Throwable)e);
                try {
                    this.fireSessionClosed((SessionImplSocket)sessionImpl, e);
                    this.sessionMap.remove(sessionImpl);
                    sessionImpl = null;
                }
                catch (Throwable throwable) {}
                throw new DatabaseException(e);
            }
        }
        finally {
            if (!ok && sessionImpl != null) {
                ((LifecycleSupport)sessionImpl.getService(LifecycleSupport.class)).close();
            }
        }
        return sessionImpl;
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove((Object)listener);
    }

    private void fireSessionOpened(SessionImplSocket session) {
        SessionEvent se = new SessionEvent((Session)session, null);
        SessionListener[] sessionListenerArray = (SessionListener[])this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionOpened(se);
            ++n2;
        }
    }

    private void fireSessionClosed(SessionImplSocket session, Throwable cause) {
        SessionEvent se = new SessionEvent((Session)session, cause);
        SessionListener[] sessionListenerArray = (SessionListener[])this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionClosed(se);
            ++n2;
        }
    }

    public void shutdown(Session s, Throwable cause) {
        SessionImplSocket sis = (SessionImplSocket)s;
        if (sis == null) {
            return;
        }
        try {
            this.fireSessionClosed(sis, cause);
        }
        finally {
            this.sessionMap.remove(s);
        }
    }

    public SessionErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SessionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static synchronized AcornSessionManagerImpl getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AcornSessionManagerImpl();
        }
        return INSTANCE;
    }

    public Database getDatabase() {
        return this.database;
    }

    public GraphClientImpl2 getClient() {
        if (this.sessionMap.values().size() > 1) {
            throw new RuntimeDatabaseException("Currently only one GraphClientImpl2 per session is supported!");
        }
        Database.Session client = this.sessionMap.values().iterator().next();
        return (GraphClientImpl2)client;
    }
}

