/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.store;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.compiler.internal.store.IPreValue;
import org.simantics.graph.compiler.internal.values.TreeValue;
import org.simantics.graph.query.IDataTypeQuery;
import org.simantics.graph.store.IStore;
import org.simantics.graph.store.IndexMappingUtils;
import org.simantics.graph.store.ValueStore;
import org.simantics.ltk.Problem;

public class PreValueStore
implements IStore {
    TIntObjectHashMap<IPreValue> preValues = new TIntObjectHashMap();
    TIntHashSet collisions = new TIntHashSet();

    public void map(TIntIntHashMap map) {
        this.preValues = IndexMappingUtils.map((TIntIntHashMap)map, this.preValues, (TIntHashSet)this.collisions);
    }

    public void setValue(int id, IPreValue value) {
        this.preValues.put(id, (Object)value);
    }

    public void convertPreValues(final ValueStore values, final IDataTypeQuery dtq, final Collection<Problem> problems) {
        this.preValues.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<IPreValue>(){

            public boolean execute(int resource, IPreValue preValue) {
                Binding binding;
                block3: {
                    binding = dtq.getDataType(resource);
                    if (binding != null) break block3;
                    problems.add(new Problem(preValue.getLocation(), "Literal does not have a data type."));
                    return true;
                }
                try {
                    Object value = preValue.toValue(binding, problems);
                    values.setValue(resource, new Variant(binding, value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
        });
        this.preValues.clear();
    }

    public void forEachPreValue(TIntObjectProcedure<IPreValue> procedure) {
        this.preValues.forEachEntry(procedure);
    }

    public String getStringValue(int i) {
        IPreValue value = (IPreValue)this.preValues.get(i);
        if (value == null || !(value instanceof TreeValue)) {
            return null;
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        String v = (String)((TreeValue)value).toValue((Binding)Bindings.STRING, problems);
        if (v == null || problems.size() > 0) {
            return null;
        }
        return v;
    }
}

