/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;

public class DiskWarningSystem {
    private final Collection<DiskWarningListener> listeners = new CopyOnWriteArrayList<DiskWarningListener>();
    private long limit = Long.MAX_VALUE;
    private boolean disposed = false;
    private ScheduledFuture<?> future;

    public void setLimit(long limit) {
        this.limit = limit * 1024L * 1024L;
    }

    public long get() {
        return Simantics.getDiskBytes();
    }

    public boolean check() {
        return this.get() > this.limit;
    }

    public DiskWarningSystem(int amount, TimeUnit unit) {
        this.future = Simantics.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!DiskWarningSystem.this.disposed && !DiskWarningSystem.this.check()) {
                    long bytes = DiskWarningSystem.this.get();
                    for (DiskWarningListener listener : DiskWarningSystem.this.listeners) {
                        listener.diskLow(bytes);
                    }
                }
            }
        }, 0, amount, unit);
    }

    public boolean addListener(DiskWarningListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(DiskWarningListener listener) {
        return this.listeners.remove(listener);
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.future.cancel(false);
            this.listeners.clear();
        }
    }

    public static interface DiskWarningListener {
        public void diskLow(long var1);
    }
}

