/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphviz.drawable;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.VolatileImage;
import org.simantics.graphviz.drawable.Drawable;

public class ViewerCanvas
extends Canvas {
    private static final long serialVersionUID = -1094658958968314511L;
    AffineTransform transform;
    Point prev;
    VolatileImage im;
    Drawable drawable;

    public ViewerCanvas(Drawable drawable) {
        this.drawable = drawable;
        this.setBackground(Color.WHITE);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '1') {
                    ViewerCanvas.this.fit();
                    ViewerCanvas.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ViewerCanvas.this.prev = e.getPoint();
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point cur = e.getPoint();
                double deltaX = cur.getX() - ViewerCanvas.this.prev.getX();
                double deltaY = cur.getY() - ViewerCanvas.this.prev.getY();
                ViewerCanvas.this.transform.preConcatenate(AffineTransform.getTranslateInstance(deltaX, deltaY));
                ViewerCanvas.this.repaint();
                ViewerCanvas.this.prev = cur;
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (ViewerCanvas.this.transform != null) {
                    double scale = Math.exp(-0.1 * (double)e.getUnitsToScroll());
                    Point p = e.getPoint();
                    AffineTransform mod = new AffineTransform();
                    mod.translate(p.getX(), p.getY());
                    mod.scale(scale, scale);
                    mod.translate(-p.getX(), -p.getY());
                    ViewerCanvas.this.transform.preConcatenate(mod);
                    ViewerCanvas.this.repaint();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (ViewerCanvas.this.getWidth() > 0 && ViewerCanvas.this.getHeight() > 0) {
                    ViewerCanvas.this.im = ViewerCanvas.this.createVolatileImage(ViewerCanvas.this.getWidth(), ViewerCanvas.this.getHeight());
                    ViewerCanvas.this.repaint();
                }
            }
        });
    }

    public void fit() {
        Rectangle2D bounds = this.drawable.getBounds();
        Rectangle container = this.getBounds();
        double scale = Math.min(((RectangularShape)container).getWidth() / bounds.getWidth(), ((RectangularShape)container).getHeight() / bounds.getHeight());
        this.transform = new AffineTransform(scale, 0.0, 0.0, scale, ((RectangularShape)container).getX() + ((RectangularShape)container).getWidth() * 0.5 - bounds.getCenterX() * scale, ((RectangularShape)container).getY() + ((RectangularShape)container).getHeight() * 0.5 - bounds.getCenterY() * scale);
    }

    @Override
    public void paint(Graphics _g) {
        do {
            if (this.im == null || this.im.validate(this.getGraphicsConfiguration()) == 2) {
                this.im = this.createVolatileImage(this.getWidth(), this.getHeight());
            }
            Graphics2D g = (Graphics2D)this.im.getGraphics();
            g.clearRect(0, 0, this.im.getWidth(null), this.im.getHeight(null));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.transform == null) {
                this.fit();
            }
            g.setTransform(this.transform);
            this.drawable.draw(g, null);
            g.dispose();
        } while (this.im.contentsLost());
        _g.drawImage(this.im, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }
}

