/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.document.DocumentResource;
import org.simantics.document.DocumentSettings;
import org.simantics.document.Exportable;
import org.simantics.document.function.WikiDocumentNodeImpl;
import org.simantics.document.node.Composite;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.wiki.ui.SimanticsDialect;

public class DocumentUtils {
    public DocumentSettings getDocumentSettings(RequestProcessor processor, Resource resource) throws DatabaseException {
        return (DocumentSettings)processor.syncRequest((Read)new ResourceRead<DocumentSettings>(resource){

            public DocumentSettings perform(ReadGraph graph) throws DatabaseException {
                Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(this.resource));
                if (indexRoot == null) {
                    return DocumentSettings.DEFAULT;
                }
                DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                DocumentSettings result = (DocumentSettings)graph.getPossibleRelatedValue(indexRoot, DOC.documentSettings, DocumentSettings.BINDING);
                if (result == null) {
                    return DocumentSettings.DEFAULT;
                }
                return result;
            }
        });
    }

    public void getDocumentCSSText(RequestProcessor processor, Resource resource, StringBuilder css) throws DatabaseException {
        css.append((String)processor.sync((ReadInterface)new ResourceRead<String>(resource){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(this.resource));
                if (indexRoot == null) {
                    return "";
                }
                DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                String css = (String)graph.getPossibleRelatedValue(indexRoot, DOC.cssDocument, (Binding)Bindings.STRING);
                if (css == null) {
                    return "";
                }
                return css;
            }
        }));
    }

    public void getDocumentWikiTextRecursive(Session session, Resource resource, StringBuilder wiki, StringBuilder css) throws DatabaseException {
        List rs = (List)session.sync((ReadInterface)new DeepDocs(resource));
        for (Resource r : rs) {
            this.getDocumentWikiText(session, r, wiki);
        }
        this.getDocumentCSSText((RequestProcessor)session, resource, css);
    }

    public void getDocumentWikiText(Session session, final Resource resource, StringBuilder b) {
        try {
            final ScenegraphLoaderProcess loader = new ScenegraphLoaderProcess((INode)new Composite(), "CreatePDFAction");
            final Variable context = (Variable)session.sync((WriteInterface)new WriteResultRequest<Variable>((VirtualGraph)session.getService(VirtualGraph.class)){

                public Variable perform(WriteGraph graph) throws DatabaseException {
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    Resource doc = graph.getPossibleObject(resource, DOC.HasDocument);
                    if (doc == null) {
                        return null;
                    }
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    Resource runtime = graph.newResource();
                    graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)resource);
                    String uri = base.getURI((ReadGraph)graph);
                    graph.claimLiteral(runtime, SG.Runtime_HasVariable, (Object)uri, (Binding)Bindings.STRING);
                    return new ScenegraphVariable(base, doc, runtime, loader.getRoot());
                }
            });
            if (context == null) {
                return;
            }
            String wiki = (String)session.sync((ReadInterface)new UniqueRead<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
                    Resource doc = graph.getSingleObject(resource, DOC.HasDocumentation);
                    Resource scenegraph = graph.getSingleObject(doc, DOC.ScenegraphDocument_scenegraph);
                    WikiDocumentNodeImpl node = (WikiDocumentNodeImpl)loader.load((RequestProcessor)graph, scenegraph, ScenegraphLoaderUtils.getRuntime((ReadGraph)graph, (Variable)context));
                    StringBuilder b = new StringBuilder();
                    node.create(b, true);
                    String text = b.toString();
                    return SimanticsDialect.INSTANCE.apply(graph, Variables.getVariable((ReadGraph)graph, (Resource)resource), text);
                }
            });
            loader.dispose();
            b.append(wiki);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public int print(RequestProcessor processor, final Resource res, final String wiki, final String css, final DocumentSettings settings, PdfWriter writer, Document document) throws DocumentException, DatabaseException {
        Exportable exp = (Exportable)processor.syncRequest((Read)new UniqueRead<Exportable>(){

            public Exportable perform(ReadGraph graph) throws DatabaseException {
                return new Exportable(graph, res, wiki, css, settings, true);
            }
        });
        return exp.export(document, writer);
    }

    public static String indexRootPath(ReadGraph graph, Variable selection) throws DatabaseException {
        String configurationURI;
        Resource indexRoot;
        Variable possibleConfiguration = Variables.getPossibleConfigurationVariable((ReadGraph)graph, (Variable)selection);
        if (possibleConfiguration != null) {
            selection = possibleConfiguration;
        }
        if ((indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(selection.getRepresents(graph)))) == null) {
            return "";
        }
        String selectionURI = selection.getParent(graph).getURI(graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource configuration = graph.getPossibleObject(indexRoot, SIMU.HasConfiguration);
        if (configuration != null && selectionURI.startsWith(configurationURI = graph.getURI(configuration))) {
            if (selectionURI.equals(configurationURI)) {
                return "Configuration / ";
            }
            return URIStringUtils.unescape((String)(String.valueOf(selectionURI.substring(configurationURI.length() + 1).replace("/", " / ")) + " / "));
        }
        String rootURI = graph.getURI(indexRoot);
        String result = selectionURI.replace(rootURI, "");
        if (result.isEmpty()) {
            result = "/";
        }
        return URIStringUtils.unescape((String)result);
    }

    static class DeepDocs
    extends ResourceRead<List<Resource>> {
        protected DeepDocs(Resource resource) {
            super(resource);
        }

        public List<Resource> perform(ReadGraph graph) throws DatabaseException {
            DocumentResource DOC = DocumentResource.getInstance((ReadGraph)graph);
            Resource doc = graph.getPossibleObject(this.resource, DOC.HasDocument);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Collection children = graph.getObjects(this.resource, L0.ConsistsOf);
            if (children.isEmpty()) {
                if (doc != null) {
                    return Collections.singletonList(this.resource);
                }
                return Collections.emptyList();
            }
            ArrayList<Resource> result = new ArrayList<Resource>();
            if (doc != null) {
                result.add(this.resource);
            }
            for (Resource child : children) {
                result.addAll((Collection)graph.syncRequest((Read)new DeepDocs(child)));
            }
            return result;
        }
    }
}

