/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.internal.Activator;
import org.simantics.utils.ui.internal.awt.AwtEnvironment;
import org.simantics.utils.ui.internal.awt.AwtFocusHandler;
import org.simantics.utils.ui.internal.awt.CleanResizeListener;
import org.simantics.utils.ui.internal.awt.EmbeddedChildFocusTraversalPolicy;
import org.simantics.utils.ui.internal.awt.SwtFocusHandler;

public abstract class SWTAWTComponent
extends Composite {
    private Font currentSystemFont;
    private AwtContext awtContext;
    private AwtFocusHandler awtHandler;
    private JApplet panel;
    private final AtomicBoolean populationStarted = new AtomicBoolean(false);
    private final AtomicBoolean populated = new AtomicBoolean(false);
    private final Semaphore populationSemaphore = new Semaphore(0);
    private Consumer<SWTAWTComponent> populatedCallback;
    private static AWTEventListener awtListener = null;
    private Listener settingsListener = new Listener(){

        public void handleEvent(Event event) {
            SWTAWTComponent.this.handleSettingsChange();
        }
    };
    private final Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            if (!$assertionsDisabled && SWTAWTComponent.this.awtHandler == null) {
                throw new AssertionError();
            }
            SWTAWTComponent.this.awtHandler.postHidePopups();
        }
    };

    public SWTAWTComponent(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000 | 0x1000000);
        this.getDisplay().addListener(39, this.settingsListener);
        this.setLayout((Layout)new FillLayout());
        this.currentSystemFont = this.getFont();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTAWTComponent.this.doDispose();
            }
        });
    }

    protected void doDispose() {
        this.getDisplay().removeListener(39, this.settingsListener);
        this.getDisplay().removeFilter(22, this.menuListener);
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AwtContext ctx = SWTAWTComponent.this.awtContext;
                if (ctx != null) {
                    ctx.frame.dispose();
                }
                SWTAWTComponent.this.awtContext = null;
                if (SWTAWTComponent.this.panel != null) {
                    SWTAWTComponent.this.panel.removeAll();
                    SWTAWTComponent.this.panel = null;
                }
            }
        });
    }

    private static synchronized void initAWTEventListener() {
        if (!AWTThread.getThreadAccess().currentThreadAccess()) {
            throw new AssertionError((Object)"not invoked from AWT thread");
        }
        if (awtListener == null) {
            awtListener = new FocusRepairListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(awtListener, 16L);
        }
    }

    protected Container getContainer() {
        return this.panel;
    }

    public Component getAWTComponent() {
        assert (this.awtContext != null);
        return this.awtContext.getSwingComponent();
    }

    public void syncPopulate() {
        this.populate();
        this.waitUntilPopulated();
    }

    public void populate(Consumer<SWTAWTComponent> callback) {
        this.populate();
        this.populatedCallback = callback;
    }

    public void populate() {
        if (!this.populationStarted.compareAndSet(false, true)) {
            throw new IllegalStateException((Object)((Object)this) + ".populate was invoked multiple times");
        }
        this.checkWidget();
        ITask task = ThreadLogger.getInstance().begin("createFrame");
        this.createFrame();
        task.finish();
        this.scheduleComponentCreation();
    }

    public void waitUntilPopulated() {
        if (this.populated.get()) {
            return;
        }
        try {
            boolean done = false;
            while (!done) {
                done = this.populationSemaphore.tryAcquire(10L, TimeUnit.MILLISECONDS);
                while (!done && this.getDisplay().readAndDispatch()) {
                    if (this.isDisposed()) {
                        return;
                    }
                    done = this.populationSemaphore.tryAcquire();
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error("EmbeddedSwingComposite population interrupted for class " + (Object)((Object)this), e);
        }
    }

    public Frame getFrame() {
        AwtContext ctx;
        if (this.getDisplay() == null || this.isDisposed()) {
            SWT.error((int)24);
        }
        return (ctx = this.awtContext) != null ? ctx.getFrame() : null;
    }

    private void createFrame() {
        assert (Display.getCurrent() != null);
        AwtEnvironment.getInstance(this.getDisplay());
        if (this.awtContext != null) {
            final Frame oldFrame = this.awtContext.getFrame();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    oldFrame.dispose();
                }
            });
        }
        Frame frame = SWT_AWT.new_Frame((Composite)this);
        this.awtContext = new AwtContext(frame);
        this.workaroundJava7FocusProblem(frame);
        this.createFocusHandlers();
        this.addControlListener((ControlListener)new CleanResizeListener());
    }

    private void workaroundJava7FocusProblem(Frame frame) {
        String ver = System.getProperty("java.version");
        if (ver.startsWith("1.7") || ver.startsWith("1.8")) {
            try {
                frame.addWindowListener(new Java7FocusFixListener((Control)this, frame));
            }
            catch (SecurityException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.utils.ui", e.getMessage(), (Throwable)e));
            }
            catch (NoSuchMethodException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.utils.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void createFocusHandlers() {
        assert (this.awtContext != null);
        assert (Display.getCurrent() != null);
        Frame frame = this.awtContext.getFrame();
        this.awtHandler = new AwtFocusHandler(frame);
        SwtFocusHandler swtHandler = new SwtFocusHandler(this);
        this.awtHandler.setSwtHandler(swtHandler);
        swtHandler.setAwtHandler(this.awtHandler);
        this.getDisplay().addFilter(22, this.menuListener);
        EmbeddedChildFocusTraversalPolicy policy = new EmbeddedChildFocusTraversalPolicy(this.awtHandler);
        frame.setFocusTraversalPolicy(policy);
    }

    private void scheduleComponentCreation() {
        assert (this.awtContext != null);
        final AwtContext currentContext = this.awtContext;
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SWTAWTComponent.initAWTEventListener();
                SWTAWTComponent.this.panel = SWTAWTComponent.this.addRootPaneContainer(currentContext.getFrame());
                SWTAWTComponent.this.panel.setLayout(new GridLayout(1, 1, 0, 0));
                try {
                    Component swingComponent = SWTAWTComponent.this.createSwingComponent();
                    currentContext.setSwingComponent(swingComponent);
                    SWTAWTComponent.this.panel.getRootPane().getContentPane().add(swingComponent);
                    SWTAWTComponent.this.setComponentFont();
                }
                finally {
                    SWTAWTComponent.this.populated.set(true);
                    if (SWTAWTComponent.this.populationSemaphore != null) {
                        SWTAWTComponent.this.populationSemaphore.release();
                    }
                    if (SWTAWTComponent.this.populatedCallback != null) {
                        SWTAWTComponent.this.populatedCallback.accept(SWTAWTComponent.this);
                        SWTAWTComponent.this.populatedCallback = null;
                    }
                }
            }
        });
    }

    protected JApplet addRootPaneContainer(Frame frame) {
        assert (EventQueue.isDispatchThread());
        assert (frame != null);
        JApplet applet = new JApplet();
        applet.setFocusCycleRoot(false);
        frame.add(applet);
        return applet;
    }

    protected abstract Component createSwingComponent();

    private void setComponentFont() {
        Component swingComponent;
        assert (this.currentSystemFont != null);
        assert (EventQueue.isDispatchThread());
        Component component = swingComponent = this.awtContext != null ? this.awtContext.getSwingComponent() : null;
        if (swingComponent != null && !this.currentSystemFont.getDevice().isDisposed()) {
            FontData fontData = this.currentSystemFont.getFontData()[0];
            int resolution = Toolkit.getDefaultToolkit().getScreenResolution();
            int awtFontSize = (int)Math.round((double)fontData.getHeight() * (double)resolution / 72.0);
            java.awt.Font awtFont = new java.awt.Font(fontData.getName(), fontData.getStyle(), awtFontSize);
            this.updateLookAndFeel(awtFont);
            this.updateAwtFont(awtFont);
            Container contentPane = SwingUtilities.getRootPane(swingComponent).getContentPane();
            SwingUtilities.updateComponentTreeUI(contentPane);
        }
    }

    private void updateLookAndFeel(java.awt.Font awtFont) {
        assert (awtFont != null);
        assert (EventQueue.isDispatchThread());
        FontUIResource fontResource = new FontUIResource(awtFont);
        UIManager.put("Button.font", fontResource);
        UIManager.put("CheckBox.font", fontResource);
        UIManager.put("ComboBox.font", fontResource);
        UIManager.put("EditorPane.font", fontResource);
        UIManager.put("Label.font", fontResource);
        UIManager.put("List.font", fontResource);
        UIManager.put("Panel.font", fontResource);
        UIManager.put("ProgressBar.font", fontResource);
        UIManager.put("RadioButton.font", fontResource);
        UIManager.put("ScrollPane.font", fontResource);
        UIManager.put("TabbedPane.font", fontResource);
        UIManager.put("Table.font", fontResource);
        UIManager.put("TableHeader.font", fontResource);
        UIManager.put("TextField.font", fontResource);
        UIManager.put("TextPane.font", fontResource);
        UIManager.put("TitledBorder.font", fontResource);
        UIManager.put("ToggleButton.font", fontResource);
        UIManager.put("TreeFont.font", fontResource);
        UIManager.put("ViewportFont.font", fontResource);
    }

    protected void updateAwtFont(java.awt.Font newFont) {
    }

    private void handleSettingsChange() {
        Font newFont = this.getDisplay().getSystemFont();
        if (!newFont.equals((Object)this.currentSystemFont)) {
            this.currentSystemFont = newFont;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SWTAWTComponent.this.setComponentFont();
                }
            });
        }
    }

    private static class AwtContext {
        private Frame frame;
        private Component swingComponent;

        AwtContext(Frame frame) {
            assert (frame != null);
            this.frame = frame;
        }

        Frame getFrame() {
            return this.frame;
        }

        void setSwingComponent(Component swingComponent) {
            this.swingComponent = swingComponent;
        }

        Component getSwingComponent() {
            return this.swingComponent;
        }
    }

    static class FocusRepairListener
    implements AWTEventListener {
        FocusRepairListener() {
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            Object src;
            if (e.getID() == 501 && (src = e.getSource()) instanceof Component) {
                ((Component)src).requestFocus();
            }
        }
    }

    static class Java7FocusFixListener
    extends WindowAdapter {
        Method shellSetActiveControl = Shell.class.getDeclaredMethod("setActiveControl", Control.class);
        Control control;
        Frame frame;

        public Java7FocusFixListener(Control control, Frame frame) throws NoSuchMethodException, SecurityException {
            this.frame = frame;
            this.control = control;
        }

        @Override
        public void windowActivated(WindowEvent e) {
            SWTUtils.asyncExec((Widget)this.control, new Runnable(){

                @Override
                public void run() {
                    if (control.isDisposed()) {
                        return;
                    }
                    if (control.getDisplay().getFocusControl() == control) {
                        try {
                            boolean accessible = shellSetActiveControl.isAccessible();
                            if (!accessible) {
                                shellSetActiveControl.setAccessible(true);
                            }
                            shellSetActiveControl.invoke((Object)control.getShell(), control);
                            if (!accessible) {
                                shellSetActiveControl.setAccessible(false);
                            }
                        }
                        catch (SecurityException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.utils.ui", e.getMessage(), (Throwable)e));
                        }
                        catch (IllegalArgumentException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.utils.ui", e.getMessage(), (Throwable)e));
                        }
                        catch (IllegalAccessException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.utils.ui", e.getMessage(), (Throwable)e));
                        }
                        catch (InvocationTargetException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.utils.ui", e.getCause().getMessage(), e.getCause()));
                        }
                    }
                }
            });
        }
    }
}

