/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.modelBrowser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.dnd.DndBrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.structural.ui.modelBrowser.ModelBrowser;
import org.simantics.ui.SimanticsUI;

public class ModelBrowser2
extends ModelBrowser {
    public static final Set<String> defaultBrowseContexts = Collections.singleton("http://www.simantics.org/Project-1.2/ProjectBrowseContext");
    volatile DndBrowseContext dndBrowseContext;

    public ModelBrowser2() {
        this.hideComparatorSelector = true;
        this.hideViewpointSelector = true;
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> browseContexts = new ArrayList<Resource>();
                for (String uri : ModelBrowser2.this.getBrowseContexts()) {
                    Resource browseContext = graph.getPossibleResource(uri);
                    if (browseContext == null) continue;
                    browseContexts.add(browseContext);
                }
                try {
                    ModelBrowser2.this.dndBrowseContext = DndBrowseContext.create((ReadGraph)graph, browseContexts);
                }
                catch (InvalidContribution e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                }
            }
        });
    }

    public void createPartControl(Composite parent) {
        this.propertyBrowseContexts = ModelBrowser2.loadBrowseContexts(this.getBrowseContexts());
        super.createPartControl(parent);
    }

    @Override
    protected Set<String> getBrowseContexts() {
        return defaultBrowseContexts;
    }

    protected void handleDrop(final Object data, final NodeContext target) {
        if (target == null) {
            return;
        }
        SimanticsUI.getSession().asyncRequest((Read)new Read<Runnable>(){

            public Runnable perform(ReadGraph graph) throws DatabaseException {
                if (ModelBrowser2.this.dndBrowseContext == null) {
                    return null;
                }
                return ModelBrowser2.this.dndBrowseContext.getAction(graph, target, data);
            }
        }, (Procedure)new Procedure<Runnable>(){

            public void execute(Runnable result) {
                if (result != null) {
                    result.run();
                }
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }
        });
    }

    protected DndBrowseContext getDndBrowseContext() {
        return this.dndBrowseContext;
    }
}

