/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.handler.MilestoneList;
import org.simantics.layer0.Layer0;

public class MilestoneListQuery
extends ResourceRead<MilestoneList> {
    public MilestoneListQuery(Resource eventlog) {
        super(eventlog);
    }

    public MilestoneList perform(final ReadGraph graph) throws DatabaseException {
        MilestoneList result = new MilestoneList();
        result.milestones = new ArrayList();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        ArrayList<Resource> list = new ArrayList<Resource>();
        Resource eventLog = this.resource;
        if (eventLog != null) {
            result.baseline = graph.getPossibleObject(eventLog, EVENT.EventLog_HasBaselineEvent);
            for (Resource slice : graph.getObjects(eventLog, L0.ConsistsOf)) {
                for (Resource event : graph.getObjects(slice, L0.ConsistsOf)) {
                    if (!graph.hasStatement(event, EVENT.Milestone)) continue;
                    list.add(event);
                }
            }
        }
        Collections.sort(list, new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                try {
                    Double t1 = (Double)graph.getPossibleRelatedValue(o1, EVENT.HasTimestamp);
                    Double t2 = (Double)graph.getPossibleRelatedValue(o2, EVENT.HasTimestamp);
                    if (t1 == null) {
                        t1 = 0.0;
                    }
                    if (t2 == null) {
                        t2 = 0.0;
                    }
                    return Double.compare(t1, t2);
                }
                catch (ManyObjectsForFunctionalRelationException manyObjectsForFunctionalRelationException) {
                    return 0;
                }
                catch (ServiceException serviceException) {
                    return 0;
                }
            }
        });
        result.milestones = list;
        return result;
    }

    public Resource getEventLog() {
        return this.resource;
    }
}

