/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.widgets;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.threads.SWTThread;

public class TrackedCombo
implements Widget {
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private static final int MOUSE_INSIDE_CONTROL = 8;
    private int state;
    private int caretPositionBeforeEdit;
    private String textBeforeEdit;
    private final Combo combo;
    private CompositeListener listener;
    private ListenerList modifyListeners;
    private IInputValidator validator;
    private ITrackedColorProvider colorProvider;
    private final ResourceManager resourceManager;
    private ReadFactory<?, Map<String, Object>> itemFactory;
    protected ReadFactory<?, String> selectionFactory;

    public void setItemFactory(ReadFactory<?, Map<String, Object>> itemFactory) {
        this.itemFactory = itemFactory;
    }

    public void setSelectionFactory(ReadFactory<?, String> selectionFactory) {
        this.selectionFactory = selectionFactory;
    }

    public void setFont(Font font) {
        this.combo.setFont(font);
    }

    @Override
    public void setInput(ISessionContext context, Object input) {
        if (this.modifyListeners != null) {
            Object[] objectArray = this.modifyListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof Widget) {
                    ((Widget)listener).setInput(context, input);
                }
                ++n2;
            }
        }
        if (this.itemFactory != null) {
            this.itemFactory.listen(context, input, new Listener<Map<String, Object>>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final Map<String, Object> items) {
                    if (this.isDisposed()) {
                        return;
                    }
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            Integer selectionIndex;
                            if (this.isDisposed()) {
                                return;
                            }
                            if (TrackedCombo.this.listener != null) {
                                TrackedCombo.this.combo.removeModifyListener((ModifyListener)TrackedCombo.this.listener);
                            }
                            TrackedCombo.this.combo.setData((Object)items);
                            TrackedCombo.this.combo.clearSelection();
                            try {
                                TrackedCombo.this.combo.removeAll();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            int index = 0;
                            for (String key : items.keySet()) {
                                TrackedCombo.this.combo.add(key);
                                TrackedCombo.this.combo.setData(key, (Object)index++);
                            }
                            String selectionKey = (String)TrackedCombo.this.combo.getData("_SelectionKey");
                            if (selectionKey != null && (selectionIndex = (Integer)TrackedCombo.this.combo.getData(selectionKey)) != null) {
                                TrackedCombo.this.combo.select(selectionIndex.intValue());
                            }
                            if (TrackedCombo.this.listener != null) {
                                TrackedCombo.this.combo.addModifyListener((ModifyListener)TrackedCombo.this.listener);
                            }
                        }
                    };
                    if (SWTThread.getThreadAccess().currentThreadAccess()) {
                        r.run();
                    } else {
                        TrackedCombo.this.combo.getDisplay().asyncExec(r);
                    }
                }

                public boolean isDisposed() {
                    return TrackedCombo.this.combo.isDisposed();
                }
            });
        }
        if (this.selectionFactory != null) {
            this.selectionFactory.listen(context, input, new Listener<String>(){

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public void execute(final String selectionKey) {
                    if (this.isDisposed()) {
                        return;
                    }
                    TrackedCombo.this.combo.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isDisposed()) {
                                return;
                            }
                            if (selectionKey == null) {
                                return;
                            }
                            TrackedCombo.this.combo.setData("_SelectionKey", (Object)selectionKey);
                            Integer selectionIndex = (Integer)TrackedCombo.this.combo.getData(selectionKey);
                            if (selectionIndex != null) {
                                TrackedCombo.this.combo.select(selectionIndex.intValue());
                            }
                        }
                    });
                }

                public boolean isDisposed() {
                    return TrackedCombo.this.combo.isDisposed();
                }
            });
        }
    }

    public void manualSelect(int index) {
        String key = this.combo.getItem(index);
        this.combo.setData("_SelectionKey", (Object)key);
        this.combo.select(index);
    }

    public TrackedCombo(Composite parent, WidgetSupport support, int style) {
        this.combo = new Combo(parent, style);
        this.combo.setData("org.simantics.browsing.ui.widgets.Combo", (Object)this);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.combo);
        this.colorProvider = new DefaultColorProvider();
        support.register(this);
        this.initialize();
    }

    private void initialize() {
        Assert.isNotNull((Object)this.combo);
        this.combo.setBackground(this.colorProvider.getInactiveBackground());
        this.listener = new CompositeListener();
        this.combo.addModifyListener((ModifyListener)this.listener);
        this.combo.addDisposeListener((DisposeListener)this.listener);
        this.combo.addKeyListener((KeyListener)this.listener);
        this.combo.addMouseTrackListener((MouseTrackListener)this.listener);
        this.combo.addMouseListener((MouseListener)this.listener);
        this.combo.addFocusListener((FocusListener)this.listener);
        this.combo.addSelectionListener((SelectionListener)this.listener);
    }

    private void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            System.out.println("TrackedText: BUG: startEdit called when in editing state");
        }
        this.caretPositionBeforeEdit = this.combo.getSelection().x;
        this.textBeforeEdit = this.combo.getText();
        this.setBackground(this.colorProvider.getEditingBackground());
        if (selectAll) {
            this.combo.setSelection(new Point(0, this.combo.getText().length()));
        }
        this.state |= 5;
    }

    private void applyEdit() {
        try {
            if (this.isTextValid() != null) {
                this.combo.setText(this.textBeforeEdit);
            } else if (this.isModified() && !this.combo.getText().equals(this.textBeforeEdit) && this.modifyListeners != null) {
                TrackedModifyEvent event = new TrackedModifyEvent((org.eclipse.swt.widgets.Widget)this.combo, this.combo.getText());
                Object[] objectArray = this.modifyListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((TextModifyListener)o).modifyText(event);
                    ++n2;
                }
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void endEdit() {
        if (!this.isEditing()) {
            System.out.println();
        }
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.combo.setSelection(new Point(this.combo.getText().length(), 0));
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            System.out.println("BUG: revertEdit called when not in editing state");
        }
        this.combo.setText(this.textBeforeEdit);
        this.combo.setSelection(new Point(this.caretPositionBeforeEdit, 0));
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isMouseInsideControl() {
        return (this.state & 8) != 0;
    }

    private boolean isModified() {
        return (this.state & 2) != 0;
    }

    private void setMouseInsideControl(boolean inside) {
        this.state = inside ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.combo.setEnabled(true);
            this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        } else {
            this.combo.setEnabled(false);
            this.combo.setBackground(null);
        }
    }

    public void setText(String text) {
        this.combo.setText(text);
    }

    public void setTextWithoutNotify(String text) {
        this.combo.removeModifyListener((ModifyListener)this.listener);
        this.setText(text);
        this.combo.addModifyListener((ModifyListener)this.listener);
    }

    public Combo getWidget() {
        return this.combo;
    }

    public synchronized void addModifyListener(TextModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add((Object)listener);
    }

    public synchronized void removeModifyListener(TextModifyListener listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove((Object)listener);
    }

    public void setInputValidator(IInputValidator validator) {
        if (validator != this.validator) {
            this.validator = validator;
        }
    }

    private String isTextValid() {
        if (this.validator != null) {
            return this.validator.isValid(this.getWidget().getText());
        }
        return null;
    }

    public void setColorProvider(ITrackedColorProvider provider) {
        Assert.isNotNull((Object)provider);
        this.colorProvider = provider;
    }

    public void setBackground(Color color) {
        if (!this.combo.getEnabled()) {
            return;
        }
        this.combo.setBackground(color);
    }

    public void setForeground(Color color) {
        this.combo.setForeground(color);
    }

    public boolean isDisposed() {
        return this.combo.isDisposed();
    }

    public Display getDisplay() {
        return this.combo.getDisplay();
    }

    private class CompositeListener
    implements ModifyListener,
    DisposeListener,
    KeyListener,
    MouseTrackListener,
    MouseListener,
    FocusListener,
    SelectionListener {
        private CompositeListener() {
        }

        public void modifyText(ModifyEvent e) {
            TrackedCombo.this.setModified(true);
            String valid = TrackedCombo.this.isTextValid();
            if (valid != null) {
                TrackedCombo.this.setBackground(TrackedCombo.this.colorProvider.getInvalidBackground());
            } else if (TrackedCombo.this.isEditing()) {
                TrackedCombo.this.setBackground(TrackedCombo.this.colorProvider.getEditingBackground());
            } else {
                TrackedCombo.this.setBackground(TrackedCombo.this.colorProvider.getInactiveBackground());
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TrackedCombo.this.getWidget().removeModifyListener((ModifyListener)this);
        }

        public void keyPressed(KeyEvent e) {
            if (!TrackedCombo.this.isEditing()) {
                if (e.keyCode == 27) {
                    return;
                }
                if (e.keyCode == 0x100000B) {
                    TrackedCombo.this.startEdit(true);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TrackedCombo.this.startEdit(false);
                } else if (e.keyCode == 9) {
                    TrackedCombo.this.combo.traverse((e.stateMask & 0x20000) != 0 ? 8 : 16);
                    e.doit = false;
                } else if (e.character != '\u0000') {
                    TrackedCombo.this.startEdit(false);
                }
            } else {
                if (e.keyCode == 27) {
                    TrackedCombo.this.revertEdit();
                }
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TrackedCombo.this.applyEdit();
                    e.doit = false;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!TrackedCombo.this.isEditing()) {
                TrackedCombo.this.setBackground(TrackedCombo.this.colorProvider.getHoverBackground());
            }
            TrackedCombo.this.setMouseInsideControl(true);
        }

        public void mouseExit(MouseEvent e) {
            if (!TrackedCombo.this.isEditing()) {
                TrackedCombo.this.setBackground(TrackedCombo.this.colorProvider.getInactiveBackground());
            }
            TrackedCombo.this.setMouseInsideControl(false);
        }

        public void mouseHover(MouseEvent e) {
            TrackedCombo.this.setMouseInsideControl(true);
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                TrackedCombo.this.getWidget().setSelection(new Point(0, TrackedCombo.this.combo.getText().length()));
            }
        }

        public void mouseDown(MouseEvent e) {
            if (!TrackedCombo.this.isEditing()) {
                if (e.button == 1) {
                    TrackedCombo.this.startEdit(true);
                }
            } else if (e.button == 1 && (TrackedCombo.this.state & 4) != 0) {
                TrackedCombo.this.getWidget().setSelection(new Point(0, TrackedCombo.this.combo.getText().length()));
                TrackedCombo trackedCombo = TrackedCombo.this;
                trackedCombo.state = trackedCombo.state & 0xFFFFFFFB;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (!TrackedCombo.this.isEditing()) {
                TrackedCombo.this.startEdit(true);
            }
        }

        public void focusLost(FocusEvent e) {
            if (TrackedCombo.this.isEditing()) {
                TrackedCombo.this.applyEdit();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            TrackedCombo.this.applyEdit();
        }

        public void widgetSelected(SelectionEvent e) {
            TrackedCombo.this.applyEdit();
        }
    }

    private class DefaultColorProvider
    implements ITrackedColorProvider {
        private final ColorDescriptor highlightColor = ColorDescriptor.createFrom((RGB)new RGB(254, 255, 197));
        private final ColorDescriptor inactiveColor = ColorDescriptor.createFrom((RGB)new RGB(245, 246, 190));
        private final ColorDescriptor invalidInputColor = ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128));

        private DefaultColorProvider() {
        }

        @Override
        public Color getEditingBackground() {
            return null;
        }

        @Override
        public Color getHoverBackground() {
            return TrackedCombo.this.resourceManager.createColor(this.highlightColor);
        }

        @Override
        public Color getInactiveBackground() {
            return TrackedCombo.this.resourceManager.createColor(this.inactiveColor);
        }

        @Override
        public Color getInvalidBackground() {
            return TrackedCombo.this.resourceManager.createColor(this.invalidInputColor);
        }
    }
}

