/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.selectionview;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.db.management.ISessionContext;

/**
 * A wrapper for {@link PropertyTabContributor} to label/image it and make it
 * comparable by assigning a number to it. Used in {@link SelectionProcessor}
 * implementations to contribute tabs to tabbed property pages.
 * 
 * @author Tuukka Lehtonen
 * @see PropertyTabContributor
 */
public class ComparableTabContributor implements PropertyTabContributor, Comparable<ComparableTabContributor> {

    private final PropertyTabContributor orig;
    private final double                 priority;
    private final Object                 input;
    private final String                 label;
    private final String                 id;
    private final Image                  image;

    public ComparableTabContributor(PropertyTabContributor orig, double priority, Object input, String label) {
        this(orig, priority, input, label, null);
    }

    public ComparableTabContributor(PropertyTabContributor orig, double priority, Object input, String label, Image image) {
    	this(orig, priority, input, label, label, image);
    }

    public ComparableTabContributor(PropertyTabContributor orig, double priority, Object input, String label, String id, Image image) {
        if (orig == null)
            throw new NullPointerException("null property tab contributor");
        if (input == null)
            throw new NullPointerException("null input");
        if (label == null)
            throw new NullPointerException("null label");
        this.orig = orig;
        this.priority = priority;
        this.input = input;
        this.label = label;
        this.id = id;
        this.image = image;
    }

    @Override
    public IPropertyTab create(Composite parent, IWorkbenchSite site, ISessionContext context, Object input) {
        return orig.create(parent, site, context, input);
    }

    public String getLabel() {
        return label;
    }

    public Image getImage() {
        return image;
    }

    public Object getInput() {
        return input;
    }
    
    public String getId() {
    	return id;
    }

    @Override
    public int compareTo(ComparableTabContributor o) {
        int comp = Double.compare(o.priority, priority);
        if(comp != 0) return comp;
        return id.compareTo(o.id);
    }

    @Override
    public int hashCode() {
        return orig.hashCode() ^ Double.valueOf(priority).hashCode() ^ input.hashCode() ^ label.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof ComparableTabContributor))
            return false;

        ComparableTabContributor r = (ComparableTabContributor)object;
        return orig.equals(r.orig) && priority == r.priority && input.equals(r.input) && label.equals(r.label);
    }

    @Override
    public String toString() {
        return orig + "[" + label + "] " + priority + " " + input;
    }

}