/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.typicals;

import gnu.trove.set.hash.THashSet;
import java.util.Map;
import org.simantics.db.MetadataI;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.changeset.GenericChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.genericrelation.DependenciesRelation;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.SyncTypicalTemplatesToInstances;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.MapSet;
import org.simantics.utils.ui.ErrorLogger;

public class TypicalDiagramTemplateListener
extends GenericChangeListener<DependenciesRelation.DependencyChangesRequest, DependencyChanges> {
    private static final boolean DEBUG = false;
    Layer0 L0;
    StructuralResource2 STR;
    DiagramResource DIA;
    ModelingResources MOD;
    THashSet<Resource> visited = new THashSet();
    THashSet<Resource> typicals = new THashSet();
    MapSet<Resource, Resource> changedElementsByDiagram = new MapSet.Hash();

    public void onEvent(ReadGraph graph, MetadataI metadata, DependencyChanges event) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
        this.visited.clear();
        this.typicals.clear();
        try {
            this.processChanges(graph, event);
        }
        finally {
            this.visited.clear();
            this.typicals.clear();
            this.visited.compact();
        }
    }

    private void processChanges(ReadGraph graph, DependencyChanges event) throws DatabaseException {
        for (Map.Entry entry : event.modelChanges.entrySet()) {
            DependencyChanges.Change[] changes = (DependencyChanges.Change[])entry.getValue();
            if (changes == null) continue;
            DependencyChanges.Change[] changeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyChanges.Change c = changeArray[n2];
                if (c instanceof DependencyChanges.ComponentAddition) {
                    DependencyChanges.ComponentAddition add = (DependencyChanges.ComponentAddition)c;
                    this.resolveDependentTypicalDiagrams(graph, add.component, false);
                } else if (c instanceof DependencyChanges.ComponentRemoval) {
                    DependencyChanges.ComponentRemoval rm = (DependencyChanges.ComponentRemoval)c;
                    this.resolveDependentTypicalDiagrams(graph, rm.parent, false);
                } else if (c instanceof DependencyChanges.ComponentModification) {
                    DependencyChanges.ComponentModification mod = (DependencyChanges.ComponentModification)c;
                    this.resolveDependentTypicalDiagrams(graph, mod.component, true);
                }
                ++n2;
            }
        }
        if (!this.typicals.isEmpty()) {
            this.scheduleSynchronization(graph, (Resource[])this.typicals.toArray((Object[])Resource.NONE));
        }
    }

    private void scheduleSynchronization(ReadGraph graph, Resource[] templates) {
        MapSet<Resource, Resource> changes = this.changedElementsByDiagram;
        this.changedElementsByDiagram = new MapSet.Hash();
        graph.asyncRequest((Write)new SyncTypicalTemplatesToInstances(null, templates, changes), e -> {
            if (e != null) {
                ErrorLogger.defaultLogError((String)"Typical template diagram synchronization to instances failes, see exception for details.", (Throwable)e);
            }
        });
    }

    private void resolveDependentTypicalDiagrams(ReadGraph graph, Resource component, boolean modification) throws DatabaseException {
        Resource parent;
        Resource connection;
        Resource parent2;
        if (this.visited.contains((Object)component)) {
            return;
        }
        if (graph.isInstanceOf(component, this.DIA.Diagram)) {
            this.addVisited(component, graph.hasStatement(component, this.MOD.DiagramHasInstance));
        } else if (graph.isInstanceOf(component, this.STR.Composite)) {
            Resource diagram;
            this.addVisited(diagram, (diagram = graph.getPossibleObject(component, this.MOD.CompositeToDiagram)) != null && graph.hasStatement(diagram, this.MOD.DiagramHasInstance));
        } else if (graph.isInstanceOf(component, this.STR.Component) && (parent2 = graph.getPossibleObject(component, this.L0.PartOf)) != null) {
            if (graph.isInstanceOf(component, this.DIA.Element)) {
                this.addVisited(parent2, graph.hasStatement(parent2, this.MOD.DiagramHasInstance));
                if (modification) {
                    this.changedElementsByDiagram.add((Object)parent2, (Object)component);
                }
            } else {
                Resource diagram = graph.getPossibleObject(parent2, this.MOD.CompositeToDiagram);
                if (diagram != null) {
                    Resource element;
                    this.addVisited(diagram, graph.hasStatement(diagram, this.MOD.DiagramHasInstance));
                    if (modification && (element = graph.getPossibleObject(component, this.MOD.ComponentToElement)) != null) {
                        this.changedElementsByDiagram.add((Object)diagram, (Object)element);
                    }
                }
            }
        }
        if (modification && graph.isInstanceOf(component, this.DIA.RouteNode) && (connection = ConnectionUtil.tryGetConnection((ReadGraph)graph, (Resource)component)) != null && (parent = graph.getPossibleObject(connection, this.L0.PartOf)) != null) {
            boolean isTypical = graph.hasStatement(parent, this.MOD.DiagramHasInstance);
            this.addVisited(parent, isTypical);
            if (isTypical) {
                this.changedElementsByDiagram.add((Object)parent, (Object)connection);
            }
        }
        this.addVisited(component, false);
    }

    private void addVisited(Resource r, boolean isTypical) {
        if (r != null && this.visited.add((Object)r) && isTypical) {
            this.typicals.add((Object)r);
        }
    }
}

