/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import org.simantics.xml.sax.configuration.Rename;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.AttributeGroupRef;
import org.w3._2001.xmlschema.ComplexType;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.OpenAttrs;
import org.w3._2001.xmlschema.SimpleType;

public class SchemaObject {
    private SchemaObject parent;
    private ObjectType type;
    private OpenAttrs obj;
    private Rename rename;

    public SchemaObject(Element element) {
        this(null, element);
    }

    public void setRename(Rename rename) {
        this.rename = rename;
    }

    public SchemaObject(ComplexType complexType) {
        this(null, complexType);
    }

    public SchemaObject(SimpleType simpleType) {
        this(null, simpleType);
    }

    public SchemaObject(NamedGroup namedGroup) {
        this(null, namedGroup);
    }

    public SchemaObject(SchemaObject parent, Element element) {
        this.parent = parent;
        this.obj = element;
        this.type = ObjectType.ELEMENT;
    }

    public SchemaObject(SchemaObject parent, ComplexType complexType) {
        this.parent = parent;
        this.obj = complexType;
        this.type = ObjectType.COMPLEX_TYPE;
    }

    public SchemaObject(SchemaObject parent, AttributeGroup attributeGroup) {
        this.parent = parent;
        this.obj = attributeGroup;
        this.type = ObjectType.ATTRIBUTE_GROUP;
    }

    public SchemaObject(SchemaObject parent, NamedGroup namedGroup) {
        this.parent = parent;
        this.obj = namedGroup;
        this.type = ObjectType.MODEL_GROUP;
    }

    public SchemaObject(SchemaObject parent, SimpleType simpleType) {
        this.parent = parent;
        this.obj = simpleType;
        this.type = ObjectType.SIMPLE_TYPE;
    }

    public Element getElement() {
        if (this.type != ObjectType.ELEMENT) {
            return null;
        }
        return (Element)this.obj;
    }

    public ComplexType getComplexType() {
        if (this.type != ObjectType.COMPLEX_TYPE) {
            return null;
        }
        return (ComplexType)this.obj;
    }

    public SimpleType getSimpleType() {
        if (this.type != ObjectType.SIMPLE_TYPE) {
            return null;
        }
        return (SimpleType)this.obj;
    }

    public AttributeGroup getAttributeGroup() {
        if (this.type != ObjectType.ATTRIBUTE_GROUP) {
            return null;
        }
        return (AttributeGroup)this.obj;
    }

    public NamedGroup getModelGroup() {
        if (this.type != ObjectType.MODEL_GROUP) {
            return null;
        }
        return (NamedGroup)this.obj;
    }

    public SchemaObject getParent() {
        return this.parent;
    }

    public OpenAttrs getObj() {
        return this.obj;
    }

    public String getName() {
        switch (this.type) {
            case ATTRIBUTE_GROUP: {
                if (this.obj instanceof NamedAttributeGroup) {
                    return ((NamedAttributeGroup)this.obj).getName();
                }
                return ((AttributeGroupRef)this.obj).getRef().getLocalPart();
            }
            case COMPLEX_TYPE: {
                if (this.rename != null) {
                    return this.rename.getName();
                }
                return ((ComplexType)this.obj).getName();
            }
            case ELEMENT: {
                if (this.rename != null) {
                    return this.rename.getName();
                }
                return ((Element)this.obj).getName();
            }
            case SIMPLE_TYPE: {
                return ((SimpleType)this.obj).getName();
            }
        }
        throw new RuntimeException("Unknown object type " + (Object)((Object)this.type));
    }

    public ObjectType getType() {
        return this.type;
    }

    static enum ObjectType {
        ELEMENT,
        COMPLEX_TYPE,
        SIMPLE_TYPE,
        ATTRIBUTE_GROUP,
        MODEL_GROUP;

    }
}

