/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.SchemaConversionComponent;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.w3._2001.xmlschema.AttributeGroupRef;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.Schema;

public abstract class JavaGenerator
implements SchemaConversionComponent {
    String commentTag = "//";
    Schema schema;
    String ontologyClassName;
    String ontologyUri;
    SchemaConverter converter;
    SchemaConversionBase base;
    List<String> ruleClassNames = new ArrayList<String>();
    String ontShort = "ONT";
    String name;
    File importParserDir;
    String elementPackageName;
    Map<SchemaObject, FileWriter> writers = new HashMap<SchemaObject, FileWriter>();

    public JavaGenerator(SchemaConverter converter, SchemaConversionBase base) {
        this.converter = converter;
        this.base = base;
        this.schema = base.schema;
        this.ontologyClassName = base.className;
        this.ontologyUri = base.ontologyURI;
        this.converter = converter;
        this.name = converter.name;
        this.ontShort = converter.shortName;
        this.ontShort = String.valueOf(this.ontShort) + ".";
    }

    protected PrintWriter createFile(File file) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintWriter writer = new PrintWriter(file);
        String[] stringArray = this.converter.getHeader();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            writer.println(String.valueOf(this.commentTag) + " " + s);
            ++n2;
        }
        writer.println();
        return writer;
    }

    protected String getValueGetterMethod(SchemaConversionBase.TypeEntry binding, String name) {
        if (binding == null) {
            return String.valueOf(name) + ".getValue()";
        }
        return binding.getValueGetterMethod(name);
    }

    protected String getValueGetter(SchemaConversionBase.TypeEntry binding, String name) {
        if (binding == null) {
            return name;
        }
        return binding.getValueGetter(name);
    }

    protected String getValueGetter(SchemaConversionBase.TypeEntry binding) {
        if (binding == null) {
            return "value";
        }
        return binding.getValueGetter();
    }

    @Override
    public String getSimpleTypePrefix() {
        return "SimpleTypes_";
    }

    @Override
    public String getComplexTypePrefix() {
        return "ComplexTypes_";
    }

    @Override
    public String getAttributeGroupPrefix() {
        return "AttributeGroups_";
    }

    @Override
    public String handleChoice(SchemaObject parent, SchemaElement indicator, List<SchemaElement> elements, String name) {
        String baseRelationName = String.valueOf(this.getName(parent)) + ".has" + name;
        return baseRelationName;
    }

    protected String getOntologyImport() {
        return String.valueOf(this.ontologyClassName) + " " + this.ontShort.substring(0, 3) + " = " + this.ontologyClassName + ".getInstance(graph);";
    }

    protected FileWriter getWriter(SchemaObject obj) {
        SchemaObject s = obj;
        while (s != null) {
            FileWriter fw = this.writers.get(s);
            if (fw != null) {
                return fw;
            }
            s = s.getParent();
        }
        return null;
    }

    @Override
    public String getName(SchemaObject obj) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.getComplexTypePrefix()) + obj.getName();
                }
                case ELEMENT: {
                    return obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.getAttributeGroupPrefix()) + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.getSimpleTypePrefix()) + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            String name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = String.valueOf(o.getName()) + "_" + name;
                }
                prev = o;
                o = o.getParent();
                if (!(prev.getObj() instanceof AttributeGroupRef)) continue;
                o = null;
            }
            name = name.substring(0, name.length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.getComplexTypePrefix()) + name;
                }
                case ELEMENT: {
                    return name;
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.getAttributeGroupPrefix()) + name;
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.getSimpleTypePrefix()) + name;
                }
            }
        }
        throw new RuntimeException();
    }

    public String getName(SchemaObject obj, String rel) {
        if (obj.getParent() == null) {
            switch (obj.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.getComplexTypePrefix()) + rel + obj.getName();
                }
                case ELEMENT: {
                    return String.valueOf(rel) + obj.getName();
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.getAttributeGroupPrefix()) + rel + obj.getName();
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.getSimpleTypePrefix()) + rel + obj.getName();
                }
            }
        } else {
            SchemaObject o = obj;
            SchemaObject prev = null;
            String name = "";
            while (o != null) {
                if (o.getName() != null) {
                    name = String.valueOf(o.getName()) + "_" + name;
                }
                prev = o;
                o = o.getParent();
            }
            name = name.substring(0, name.length() - 1);
            switch (prev.getType()) {
                case COMPLEX_TYPE: {
                    return String.valueOf(this.getComplexTypePrefix()) + rel + name;
                }
                case ELEMENT: {
                    return String.valueOf(rel) + name;
                }
                case ATTRIBUTE_GROUP: {
                    return String.valueOf(this.getAttributeGroupPrefix()) + rel + name;
                }
                case SIMPLE_TYPE: {
                    return String.valueOf(this.getSimpleTypePrefix()) + rel + name;
                }
            }
        }
        throw new RuntimeException();
    }

    protected void writeClass(PrintWriter writer, boolean abst, String elementId, String className, String baseClass, List<String> interfaces) {
        writer.println("@SuppressWarnings(\"unused\")");
        writer.print("public " + (abst ? "abstract " : "") + "class " + className + " extends " + baseClass);
        if (interfaces.size() > 0) {
            writer.print(" implements ");
            int i = 0;
            while (i < interfaces.size()) {
                writer.print(interfaces.get(i));
                if (i < interfaces.size() - 1) {
                    writer.print(",");
                }
                ++i;
            }
        }
        writer.println("{");
        writer.println();
        writer.println("   @Override");
        writer.println("   public java.lang.String getElementId() {");
        if (elementId != null) {
            writer.println("      return \"" + elementId + "\";");
        } else {
            writer.println("      return null;");
        }
        writer.println("   }");
        writer.println();
    }

    protected abstract void createReferenceIndicator(SchemaObject var1, SchemaConversionBase.RefType var2, String var3, String var4, String var5, String var6, boolean var7, boolean var8);

    protected abstract void createPrimitiveIndicator(SchemaObject var1, String var2, SchemaConversionBase.TypeEntry var3, QName var4);

    protected abstract void createElementIndicator(SchemaObject var1, boolean var2, String var3, String var4, boolean var5);

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement element, String refName, SchemaConversionBase.RefType referenceType, String baseRelationName) {
        if (referenceType != SchemaConversionBase.RefType.Element) {
            SchemaConversionBase.TypeEntry typeEntry;
            String objectName;
            QName refTypeName;
            SchemaObject refObject = null;
            if (referenceType == SchemaConversionBase.RefType.Type) {
                refTypeName = element.getElement().getType();
                if (refName == null) {
                    refName = element.getElement().getName();
                }
                objectName = element.getElement().getName();
                refObject = this.base.getComplexType(refTypeName);
                if (refObject == null) {
                    this.base.getSimpleType(refTypeName);
                }
            } else {
                refTypeName = element.getElement().getRef();
                if (refName == null) {
                    refName = refTypeName.getLocalPart();
                }
                objectName = refTypeName.getLocalPart();
                refObject = this.base.getElement(refTypeName);
            }
            if ((typeEntry = this.base.getTypeEntry(refTypeName)) == null) {
                String primaryClassName = null;
                String secondaryClassName = null;
                if (refObject == null) {
                    if (this.base.getSimpleType(refTypeName) != null) {
                        SchemaConversionBase.Inheritance inheritance = new SchemaConversionBase.Inheritance("");
                        this.base.getAtomicTypeInheritance(refTypeName, inheritance);
                        if (inheritance.atomicType != null) {
                            this.createPrimitiveIndicator(parent, refName, inheritance.atomicType, refTypeName);
                            return;
                        }
                        throw new RuntimeException("No supported atomic type found for simple type " + refTypeName.toString());
                    }
                    throw new RuntimeException("Type that is neither complex nor simple??");
                }
                primaryClassName = this.getName(refObject);
                if (refObject != null) {
                    secondaryClassName = this.getName(refObject);
                }
                boolean useElementList = this.base.useElementList(parent, indicator, element, referenceType == SchemaConversionBase.RefType.Reference, refName, refTypeName);
                boolean useOriginalList = this.base.useOriginalList(parent, indicator, element, referenceType == SchemaConversionBase.RefType.Reference, refName, refTypeName);
                this.createReferenceIndicator(parent, referenceType, refName, objectName, primaryClassName, secondaryClassName, useElementList, useOriginalList);
            } else {
                this.createPrimitiveIndicator(parent, refName, typeEntry, refTypeName);
            }
        } else {
            Element attrs = element.getElement();
            SchemaObject obj = this.base.getWithObj(parent, attrs);
            String className = this.getName(obj);
            if (refName == null) {
                refName = attrs.getName();
            }
            boolean useElementList = this.base.useElementList(parent, indicator, element, false, refName, new QName(obj.getName()));
            boolean useOriginalList = this.base.useOriginalList(parent, indicator, element, false, refName, new QName(obj.getName()));
            this.createElementIndicator(parent, useElementList, refName, className, useOriginalList);
        }
    }

    protected static class FileWriter {
        public PrintWriter writer;
        public PrintWriter delayedWriter;
        public PrintWriter delayedWriter2;

        protected FileWriter() {
        }
    }
}

