/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.xml.sax.JavaGenerator;
import org.simantics.xml.sax.SchemaConversionBase;
import org.simantics.xml.sax.SchemaConverter;
import org.simantics.xml.sax.SchemaElement;
import org.simantics.xml.sax.SchemaObject;
import org.simantics.xml.sax.configuration.Attribute;
import org.simantics.xml.sax.configuration.AttributeComposition;
import org.simantics.xml.sax.configuration.IDProvider;
import org.simantics.xml.sax.configuration.IDReference;
import org.simantics.xml.sax.configuration.UnrecognizedChildElement;
import org.w3._2001.xmlschema.Annotated;
import org.w3._2001.xmlschema.AttributeGroup;
import org.w3._2001.xmlschema.ComplexType;
import org.w3._2001.xmlschema.Element;
import org.w3._2001.xmlschema.List;
import org.w3._2001.xmlschema.LocalComplexType;
import org.w3._2001.xmlschema.LocalSimpleType;
import org.w3._2001.xmlschema.NamedAttributeGroup;
import org.w3._2001.xmlschema.NamedGroup;
import org.w3._2001.xmlschema.Restriction;
import org.w3._2001.xmlschema.SimpleType;

public class ImporterGenerator
extends JavaGenerator {
    IDProvider provider;

    public ImporterGenerator(SchemaConverter converter, SchemaConversionBase base) {
        super(converter, base);
    }

    public void createParser() throws IOException {
        String parserPackagePostfix = "_elem";
        String importerClassPostfix = "Importer";
        String parserClassPostfix = "Parser";
        this.elementPackageName = String.valueOf(this.name) + parserPackagePostfix;
        this.importParserDir = new File(String.valueOf(this.converter.getParserDir().getAbsolutePath()) + "/" + this.elementPackageName);
        if (!this.importParserDir.exists()) {
            this.importParserDir.mkdirs();
        }
        this.base.handle(this);
        File importerFile = new File(String.valueOf(this.converter.getParserDir().getAbsolutePath()) + "/" + this.name + importerClassPostfix + ".java");
        PrintWriter mainWriter = this.createFile(importerFile);
        mainWriter.println("package " + this.converter.getPluginName() + ";");
        mainWriter.println();
        mainWriter.println("import java.io.File;");
        mainWriter.println("import org.simantics.db.Session;");
        mainWriter.println("import org.simantics.xml.sax.base.AbstractImporter;");
        mainWriter.println();
        mainWriter.println("public class " + this.name + importerClassPostfix + " extends AbstractImporter {");
        mainWriter.println();
        mainWriter.println("   public " + this.name + importerClassPostfix + "(Session session, File file)  {");
        mainWriter.println("   \t  super(session, file, new " + this.name + parserClassPostfix + "());");
        mainWriter.println("   }");
        mainWriter.println();
        mainWriter.println("}");
        mainWriter.println();
        mainWriter.flush();
        mainWriter.close();
        File parserFile = new File(String.valueOf(this.converter.getParserDir().getAbsolutePath()) + "/" + this.name + parserClassPostfix + ".java");
        mainWriter = this.createFile(parserFile);
        mainWriter.println("package " + this.converter.getPluginName() + ";");
        mainWriter.println();
        mainWriter.println("import org.simantics.xml.sax.base.XMLParser;");
        mainWriter.println();
        mainWriter.println("public class " + this.name + parserClassPostfix + " extends XMLParser {");
        mainWriter.println();
        mainWriter.println("   public " + this.name + parserClassPostfix + "()  {");
        if (this.schema.getTargetNamespace() != null) {
            mainWriter.println("      setSchemaURI(\"" + this.schema.getTargetNamespace() + "\");");
        }
        for (String s : this.ruleClassNames) {
            mainWriter.println("      add(new " + s + "());");
        }
        mainWriter.println("   }");
        mainWriter.println("}");
        mainWriter.println();
        mainWriter.flush();
        mainWriter.close();
    }

    @Override
    public void handleSimpleType(SchemaObject parent, SchemaObject simpleTypeObj) {
    }

    @Override
    public void handle(SchemaObject parent, NamedGroup attribute) {
    }

    @Override
    public void handleComplexType(SchemaObject complexTypeObj) {
        String name;
        ComplexType topLevelComplexType = complexTypeObj.getComplexType();
        String className = name = this.getName(complexTypeObj);
        JavaGenerator.FileWriter fw = new JavaGenerator.FileWriter();
        try {
            fw.writer = this.createFile(new File(String.valueOf(this.importParserDir.getAbsolutePath()) + "/" + className + ".java"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writers.put(complexTypeObj, fw);
        SchemaConversionBase.Inheritance inheritance = this.base.getInheritance(complexTypeObj);
        this.provider = this.base.getIDProvider(topLevelComplexType);
        java.util.List<IDReference> references = this.base.getIDReferences(topLevelComplexType);
        UnrecognizedChildElement unknownChildElement = this.base.getUnknown(topLevelComplexType);
        ArrayList<String> intrerfaces = new ArrayList<String>();
        if (references.size() > 0) {
            intrerfaces.add("org.simantics.xml.sax.base.IDReferenceParser");
        }
        if (unknownChildElement != null) {
            intrerfaces.add("org.simantics.xml.sax.base.UnrecognizedElementParser");
        }
        this.createClassHeader(fw.writer, false);
        this.writeClass(fw.writer, false, null, className, inheritance.baseClass, intrerfaces);
        this.writeIDProvider(fw.writer);
        fw.writer.println("   @Override");
        fw.writer.println("   public Resource create(WriteGraph graph, ParserElement element) throws DatabaseException{");
        fw.writer.println("      Layer0 L0 = Layer0.getInstance(graph);");
        fw.writer.println("      " + this.getOntologyImport());
        fw.writer.println("      Resource res = graph.newResource();");
        fw.writer.println("      graph.claim(res, L0.InstanceOf, " + this.ontShort + name + ");");
        fw.writer.println("      return res;");
        fw.writer.println("   }");
        fw.writer.println();
        fw.writer.println("   @Override");
        fw.writer.println("   public boolean connectParent(WriteGraph graph, ParserElement parent, ParserElement element) throws DatabaseException{");
        fw.writer.println("      " + this.getOntologyImport());
        fw.writer.println("      graph.claim(parent.getData(), " + this.ontShort + this.getName(complexTypeObj, "has") + ", element.getData());");
        fw.writer.println("      return true;");
        fw.writer.println("   }");
        fw.writer.println();
        StringWriter stringWriter = new StringWriter();
        fw.delayedWriter = new PrintWriter(stringWriter);
        StringWriter stringWriter2 = new StringWriter();
        fw.delayedWriter2 = new PrintWriter(stringWriter2);
        fw.writer.println("   public " + className + "() {");
        fw.writer.println("      super();");
        this.base.handleComplexTypeExtension(complexTypeObj);
        fw.writer.println("   }");
        fw.writer.println("   @Override");
        fw.writer.println("   public boolean connectChild(WriteGraph graph, ParserElement element, ParserElement child) throws DatabaseException{");
        fw.writer.println("      " + this.getOntologyImport());
        if (stringWriter.getBuffer().length() > 0) {
            fw.writer.write(stringWriter.toString());
        }
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("      return super.connectChild(graph,element,child);");
        } else {
            fw.writer.println("      return false;");
        }
        fw.writer.println("   }");
        fw.writer.println();
        if (stringWriter2.getBuffer().length() > 0) {
            fw.writer.write(stringWriter2.toString());
        }
        stringWriter = null;
        fw.delayedWriter.close();
        fw.delayedWriter = null;
        stringWriter2 = null;
        fw.delayedWriter2.close();
        fw.delayedWriter2 = null;
        fw.writer.println("   @Override");
        fw.writer.println("   public void configure(WriteGraph graph, Deque<ParserElement> parents, ParserElement element) throws DatabaseException {");
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("      super.configure(graph,parents,element);");
        }
        fw.writer.println("      " + this.getOntologyImport());
        fw.writer.println("      Layer0 L0 = Layer0.getInstance(graph);");
        fw.writer.println("      XMLResource XML = XMLResource.getInstance(graph);");
        this.base.handleComplexTypeAttributes(complexTypeObj);
        this.base.handleExtensionAttributes(complexTypeObj);
        fw.writer.println("   }");
        if (inheritance.type == SchemaConversionBase.InheritanceType.AtomicType) {
            fw.writer.println();
            fw.writer.println("   @Override");
            fw.writer.println("   public void configure(WriteGraph graph, ParserElement element, java.lang.String string) throws DatabaseException {");
            fw.writer.println("      graph.claimValue(element.getData(), " + this.getValueGetter(inheritance.atomicType, "string") + ", " + inheritance.atomicType.binding + ");");
            fw.writer.println("   }");
        }
        this.writeIDReferences(fw.writer, name, references);
        this.writeUnknownChild(fw.writer, name, unknownChildElement);
        fw.writer.println("}");
        fw.writer.println();
        fw.writer.flush();
        fw.writer.close();
        fw.writer = null;
        this.writers.remove(complexTypeObj);
        this.provider = null;
    }

    @Override
    public void createReferenceIndicator(SchemaObject parent, SchemaConversionBase.RefType referenceType, String refName, String objectName, String primaryClassName, String secondaryClassName, boolean useElementList, boolean useOriginalList) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        if (referenceType == SchemaConversionBase.RefType.Type) {
            secondaryClassName = String.valueOf(this.getName(parent)) + "_" + objectName;
            fw.writer.println("        addParser(\"" + objectName + "\", " + secondaryClassName + ".class);");
            fw.delayedWriter2.println("   public static class " + secondaryClassName + " extends " + primaryClassName + "{");
            fw.delayedWriter2.println("      public " + secondaryClassName + "(){");
            fw.delayedWriter2.println("      }");
            fw.delayedWriter2.println("   }");
        } else {
            fw.writer.println("        addParser(" + primaryClassName + ".class);");
            if (!primaryClassName.equals(secondaryClassName)) {
                fw.writer.println("        addParser(" + secondaryClassName + ".class);");
            }
        }
        fw.delayedWriter.println("         if (child.getElementParser() instanceof " + secondaryClassName + "){");
        fw.delayedWriter.println("            graph.claim(element.getData(), " + this.ontShort + this.getName(parent) + "_has" + refName + ", child.getData());");
        if (useElementList) {
            fw.delayedWriter.println("            {");
            fw.delayedWriter.println("               element.registerListChild(" + this.ontShort + this.getName(parent) + "_has" + refName + "_List, child);");
            fw.delayedWriter.println("            }");
        }
        if (useOriginalList) {
            fw.delayedWriter.println("            {");
            fw.delayedWriter.println("               XMLResource XML = XMLResource.getInstance(graph);");
            fw.delayedWriter.println("               element.registerListChild(XML.hasOriginalElementList, child);");
            fw.delayedWriter.println("            }");
        }
        fw.delayedWriter.println("            return true;");
        fw.delayedWriter.println("         }");
    }

    @Override
    protected void createPrimitiveIndicator(SchemaObject parent, String refName, SchemaConversionBase.TypeEntry typeEntry, QName typeName) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        String className = String.valueOf(this.getName(parent)) + "_" + refName;
        fw.writer.println("        addParser(\"" + refName + "\", " + className + ".class);");
        fw.delayedWriter2.println("   public static class " + className + " extends org.simantics.xml.sax.base.ValueElementParser {");
        fw.delayedWriter2.println("      public " + className + "(){");
        fw.delayedWriter2.println("         super(\"" + refName + "\"," + this.ontologyClassName + ".URIs." + this.getName(parent) + "_has" + refName + ", " + typeEntry.binding + ");");
        fw.delayedWriter2.println("      }\n");
        fw.delayedWriter2.println("      @Override");
        fw.delayedWriter2.println("      public void configure(WriteGraph graph, ParserElement element, java.lang.String value)\tthrows DatabaseException {");
        fw.delayedWriter2.println("         Layer0 L0 = Layer0.getInstance(graph);");
        SchemaObject simpleType = this.base.getSimpleType(typeName);
        String ontologyClassName = this.converter.getOntologyClassName(typeName.getNamespaceURI());
        if (ontologyClassName != null && simpleType != null) {
            fw.delayedWriter2.println("         graph.claim(element.getData(), L0.InstanceOf, " + ontologyClassName + ".getInstance(graph)." + this.getName(simpleType, "") + ");");
        } else {
            if (typeEntry.l0Type.startsWith("XML")) {
                fw.delayedWriter2.println("         XMLResource XML = XMLResource.getInstance(graph);");
            }
            fw.delayedWriter2.println("         graph.claim(element.getData(), L0.InstanceOf, " + typeEntry.l0Type + ");");
        }
        fw.delayedWriter2.println("         graph.claimValue(element.getData(), " + this.getValueGetter(typeEntry) + ", " + typeEntry.binding + ");");
        fw.delayedWriter2.println("      }");
        fw.delayedWriter2.println("   }");
    }

    @Override
    protected void createElementIndicator(SchemaObject parent, boolean useElementList, String refName, String className, boolean useOriginalList) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        fw.writer.println("        addParser(\"" + refName + "\", " + className + ".class);");
        fw.delayedWriter.println("         if (child.getElementParser() instanceof " + className + "){");
        fw.delayedWriter.println("            graph.claim(element.getData(), " + this.ontShort + this.getName(parent) + "_has" + refName + ", child.getData());");
        if (useElementList) {
            fw.delayedWriter.println("            {");
            fw.delayedWriter.println("               element.registerListChild(" + this.ontShort + this.getName(parent) + "_has" + refName + "_List, child);");
            fw.delayedWriter.println("            }");
        }
        if (useOriginalList) {
            fw.delayedWriter.println("            {");
            fw.delayedWriter.println("               XMLResource XML = XMLResource.getInstance(graph);");
            fw.delayedWriter.println("               element.registerListChild(XML.hasOriginalElementList, child);");
            fw.delayedWriter.println("            }");
        }
        fw.delayedWriter.println("            return true;");
        fw.delayedWriter.println("         }");
    }

    @Override
    public void handleIndicator(SchemaObject parent, SchemaElement indicator, SchemaElement any) {
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        fw.delayedWriter2.println("   @Override");
        fw.delayedWriter2.println("   public Class<? extends org.simantics.xml.sax.base.XMLElementParser> getParser(java.util.Map<java.lang.String,org.simantics.xml.sax.base.XMLElementParser> parsers, ParserElement element, ParserElement child) {");
        fw.delayedWriter2.println("      Class<? extends org.simantics.xml.sax.base.XMLElementParser> parserClass = super.getParser(parsers, element, child);");
        fw.delayedWriter2.println("      if (parserClass != null) return parserClass;");
        fw.delayedWriter2.println("      org.simantics.xml.sax.base.XMLElementParser parser = parsers.get(child.getQName());");
        fw.delayedWriter2.println("      if (parser != null) return parser.getClass();");
        fw.delayedWriter2.println("      return null;");
        fw.delayedWriter2.println("   }");
    }

    @Override
    public void handle(SchemaObject parent, org.w3._2001.xmlschema.Attribute attribute) {
        String relationName;
        String attrName;
        if (parent == null) {
            return;
        }
        String name = attribute.getName();
        QName primitiveType = attribute.getType();
        SimpleType simpleType = attribute.getSimpleType();
        QName ref = attribute.getRef();
        if (name != null) {
            attrName = name;
            relationName = String.valueOf(this.ontShort) + "has" + name;
            if (parent != null) {
                relationName = String.valueOf(this.ontShort) + this.getName(parent) + "_has" + name;
            }
        } else if (ref != null && parent != null) {
            attrName = ref.getLocalPart();
            relationName = String.valueOf(this.ontShort) + this.getName(parent) + "_has" + ref.getLocalPart();
            org.w3._2001.xmlschema.Attribute referred = this.base.getRefAttribute(ref);
            if (referred != null) {
                primitiveType = referred.getType();
                simpleType = referred.getSimpleType();
            }
        } else {
            throw new RuntimeException();
        }
        boolean isReference = false;
        if (this.provider != null && this.provider.getAttribute().getName().equals(attrName)) {
            isReference = true;
        }
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        if (primitiveType != null) {
            SchemaObject simpleTypeObj;
            SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(primitiveType);
            if (binding != null) {
                this.writeAttribute(fw, attrName, relationName, binding, isReference, primitiveType);
                return;
            }
            if (simpleType == null && (simpleTypeObj = this.base.getSimpleType(primitiveType)) != null) {
                simpleType = simpleTypeObj.getSimpleType();
            }
        }
        if (simpleType != null) {
            List list = simpleType.getList();
            if (list != null) {
                QName typeName = new QName("http://www.w3.org/2001/XMLSchema", "string");
                SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(typeName);
                this.writeAttribute(fw, attrName, relationName, binding, isReference, typeName);
            } else {
                QName base = this.base.getSimpleTypeBase(simpleType);
                SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(base);
                this.writeAttribute(fw, attrName, relationName, binding, isReference, base);
            }
        } else {
            fw.writer.println("    //FIXME: Cannot resolve type for Attribute " + attrName + " Using default type String");
            this.writeAttribute(fw, attrName, relationName, this.base.getTypeEntry("string"), isReference, new QName("http://www.w3.org/2001/XMLSchema", "string"));
        }
    }

    private void writeAttribute(JavaGenerator.FileWriter fw, String attrName, String relationName, SchemaConversionBase.TypeEntry binding, boolean isReference, QName typeName) {
        String ontologyClassName = this.converter.getOntologyClassName(typeName.getNamespaceURI());
        String ontologyType = ontologyClassName != null ? String.valueOf(ontologyClassName) + ".getInstance(graph)." + this.getName(this.base.getSimpleType(typeName)) : binding.l0Type;
        fw.writer.println("      {");
        fw.writer.println("         Attribute a = element.getAttribute(\"" + attrName + "\");");
        fw.writer.println("         if (a != null) {");
        fw.writer.println("            graph.claimLiteral(element.getData(), " + relationName + ", " + ontologyType + ", " + this.getValueGetterMethod(binding, "a") + ", " + binding.binding + ");");
        if (isReference) {
            fw.writer.println("            idProviderValue = a.getValue();");
        }
        fw.writer.println("         }");
        fw.writer.println("      }");
    }

    @Override
    public void handleAttributes(SchemaObject simpleTypeObj) {
        SchemaObject parent = simpleTypeObj.getParent();
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        SimpleType simpleType = simpleTypeObj.getSimpleType();
        Restriction restriction = simpleType.getRestriction();
        if (restriction == null) {
            throw new RuntimeException("Cannot resolve type for Element " + this.getName(parent));
        }
        QName base = restriction.getBase();
        SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(base);
        fw.writer.println("   @Override");
        fw.writer.println("   public void configure(WriteGraph graph, ParserElement element, java.lang.String value) throws DatabaseException {");
        fw.writer.println("      graph.claimValue(element.getData()," + this.getValueGetter(binding) + ", " + binding.binding + ");");
        fw.writer.println("   }");
    }

    @Override
    public void handle(SchemaObject parent, AttributeGroup attribute) {
        if (parent != null) {
            JavaGenerator.FileWriter fw = this.getWriter(parent);
            NamedAttributeGroup group = this.base.getAttributeGroup(attribute.getRef());
            fw.writer.println(String.valueOf(this.commentTag) + "    AttributeGroup " + group.getName());
            SchemaObject obj = new SchemaObject(parent, attribute);
            for (Annotated annotated : group.getAttributeOrAttributeGroup()) {
                if (annotated instanceof org.w3._2001.xmlschema.Attribute) {
                    this.handle(obj, (org.w3._2001.xmlschema.Attribute)annotated);
                    continue;
                }
                if (!(annotated instanceof AttributeGroup)) continue;
                this.handle(obj, (AttributeGroup)annotated);
            }
            System.out.println();
            fw.writer.println(String.valueOf(this.commentTag) + "    End of AttributeGroup " + group.getName());
        }
    }

    @Override
    public void handleAttributeComposition(SchemaObject parent, AttributeComposition composition, BijectionMap<Attribute, Annotated> attributes) {
        String relationName;
        JavaGenerator.FileWriter fw = this.getWriter(parent);
        QName type = new QName("http://www.simantics.org/Layer0", composition.getType());
        String arrayBinding = this.base.getBindingFromPrimitiveType(type);
        String javaType = this.base.getJavaTypeFromPrimitiveType(type);
        String name = composition.getName();
        if (name != null) {
            relationName = String.valueOf(this.ontShort) + "has" + name;
            if (parent != null) {
                relationName = String.valueOf(this.ontShort) + this.getName(parent) + "_has" + name;
            }
        } else {
            throw new RuntimeException();
        }
        fw.writer.println("      {");
        int i = 0;
        for (Attribute a : composition.getAttribute()) {
            fw.writer.println("         Attribute a" + i++ + " = element.getAttribute(\"" + a.getName() + "\");");
        }
        fw.writer.print("         " + javaType + " value = new " + javaType + "{");
        i = 0;
        for (Attribute a : composition.getAttribute()) {
            org.w3._2001.xmlschema.Attribute attribute = (org.w3._2001.xmlschema.Attribute)attributes.getRight((Object)a);
            QName atype = this.base.getPrimitiveType(attribute);
            String defaultValue = attribute.getDefault();
            if (defaultValue == null) {
                defaultValue = this.base.getDefaultValue(atype);
            }
            SchemaConversionBase.TypeEntry binding = this.base.getTypeEntry(atype);
            if (i > 0) {
                fw.writer.print(",");
            }
            if (defaultValue != null) {
                fw.writer.print("a" + i + "!= null ? " + this.getValueGetterMethod(binding, "a" + i++) + " : " + defaultValue);
                continue;
            }
            fw.writer.print(this.getValueGetterMethod(binding, "a" + i++));
        }
        fw.writer.println("};");
        fw.writer.println("         graph.claimLiteral(element.getData()," + relationName + ", value, " + arrayBinding + ");");
        fw.writer.println("      }");
    }

    @Override
    public void handleElement(SchemaObject elementObj) {
        String name;
        Element element = elementObj.getElement();
        String className = name = this.getName(elementObj);
        JavaGenerator.FileWriter fw = new JavaGenerator.FileWriter();
        try {
            fw.writer = this.createFile(new File(String.valueOf(this.importParserDir.getAbsolutePath()) + "/" + className + ".java"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.writers.put(elementObj, fw);
        boolean isList = false;
        SchemaConversionBase.Inheritance inheritance = this.base.getInheritance(elementObj);
        this.provider = this.base.getIDProvider(element);
        java.util.List<IDReference> references = this.base.getIDReferences(element);
        UnrecognizedChildElement unknownChildElement = this.base.getUnknown(element);
        ArrayList<String> intrerfaces = new ArrayList<String>();
        if (references.size() > 0) {
            intrerfaces.add("org.simantics.xml.sax.base.IDReferenceParser");
        }
        if (unknownChildElement != null) {
            intrerfaces.add("org.simantics.xml.sax.base.UnrecognizedElementParser");
        }
        this.createClassHeader(fw.writer, isList);
        this.writeClass(fw.writer, false, element.getName(), className, inheritance.baseClass, intrerfaces);
        this.writeIDProvider(fw.writer);
        fw.writer.println("   @Override");
        fw.writer.println("   public Resource create(WriteGraph graph, ParserElement element) throws DatabaseException{");
        fw.writer.println("      Layer0 L0 = Layer0.getInstance(graph);");
        fw.writer.println("      " + this.getOntologyImport());
        if (!isList) {
            fw.writer.println("      Resource res = graph.newResource();");
            fw.writer.println("      graph.claim(res, L0.InstanceOf, " + this.ontShort + name + ");");
        } else {
            fw.writer.println("      Resource res = ListUtils.create(graph, " + this.ontShort + name + ", Collections.EMPTY_LIST);");
        }
        fw.writer.println("      return res;");
        fw.writer.println("   }");
        fw.writer.println();
        fw.writer.println("   @Override");
        fw.writer.println("   public boolean connectParent(WriteGraph graph, ParserElement parent, ParserElement element) throws DatabaseException{");
        fw.writer.println("      " + this.getOntologyImport());
        fw.writer.println("      graph.claim(parent.getData(), " + this.ontShort + this.getName(elementObj, "has") + ", element.getData());");
        fw.writer.println("      return true;");
        fw.writer.println("   }");
        fw.writer.println();
        fw.writer.println("   @Override");
        fw.writer.println("   public void configure(WriteGraph graph, Deque<ParserElement> parents, ParserElement element) throws DatabaseException {");
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("      super.configure(graph,parents,element);");
        }
        fw.writer.println("      Layer0 L0 = Layer0.getInstance(graph);");
        fw.writer.println("      XMLResource XML = XMLResource.getInstance(graph);");
        fw.writer.println("      " + this.getOntologyImport());
        LocalComplexType complexType = element.getComplexType();
        LocalSimpleType simpleType = element.getSimpleType();
        if (complexType != null) {
            SchemaObject obj = this.base.getComplexType(complexType);
            this.base.handleElementComplexTypeAttributes(obj);
        }
        fw.writer.println("   }");
        if (inheritance.type == SchemaConversionBase.InheritanceType.AtomicType) {
            fw.writer.println();
            fw.writer.println("   @Override");
            fw.writer.println("   public void configure(WriteGraph graph, ParserElement element, java.lang.String string) throws DatabaseException {");
            fw.writer.println("      graph.claimValue(element.getData(), " + this.getValueGetter(inheritance.atomicType, "string") + ", " + inheritance.atomicType.binding + ");");
            fw.writer.println("   }");
        }
        StringWriter stringWriter = new StringWriter();
        fw.delayedWriter = new PrintWriter(stringWriter);
        StringWriter stringWriter2 = new StringWriter();
        fw.delayedWriter2 = new PrintWriter(stringWriter2);
        fw.writer.println("   public " + className + "() {");
        fw.writer.println("      super();");
        if (complexType != null) {
            SchemaObject obj = this.base.getComplexType(complexType);
            this.base.handleComplexTypeExtension(obj);
        }
        fw.writer.println("   }");
        fw.writer.println("   @Override");
        fw.writer.println("   public boolean connectChild(WriteGraph graph, ParserElement element, ParserElement child) throws DatabaseException{");
        fw.writer.println("      " + this.getOntologyImport());
        if (stringWriter.getBuffer().length() > 0) {
            fw.writer.write(stringWriter.toString());
        }
        if (inheritance.type == SchemaConversionBase.InheritanceType.ComplexType) {
            fw.writer.println("      return super.connectChild(graph,element,child);");
        } else {
            fw.writer.println("      return false;");
        }
        fw.writer.println("   }");
        fw.writer.println();
        if (stringWriter2.getBuffer().length() > 0) {
            fw.writer.write(stringWriter2.toString());
        }
        stringWriter = null;
        fw.delayedWriter.close();
        fw.delayedWriter = null;
        stringWriter2 = null;
        fw.delayedWriter2.close();
        fw.delayedWriter2 = null;
        this.writeIDReferences(fw.writer, name, references);
        this.writeUnknownChild(fw.writer, name, unknownChildElement);
        fw.writer.println("}");
        fw.writer.println();
        fw.writer.flush();
        fw.writer.close();
        fw.writer = null;
        this.writers.remove(elementObj);
        this.provider = null;
        this.ruleClassNames.add(String.valueOf(this.converter.getPluginName()) + "." + this.elementPackageName + "." + name);
    }

    private void writeIDProvider(PrintWriter writer) {
        if (this.provider != null) {
            writer.println("   java.lang.String idProviderValue = null;");
            writer.println();
            writer.println("   @Override");
            writer.println("   public java.lang.String getID() {");
            writer.println("   \tjava.lang.String s = idProviderValue;");
            writer.println("   \tidProviderValue = null;");
            writer.println("   \treturn s;");
            writer.println("   }");
            writer.println();
            if (this.provider.getPriority() != null) {
                writer.println("   @Override");
                writer.println("   public int idPriority() {");
                writer.println("   \treturn " + this.provider.getPriority().intValue() + ";");
                writer.println("   }");
            }
        }
    }

    private void writeIDReferences(PrintWriter writer, String name, java.util.List<IDReference> references) {
        if (references.size() > 0) {
            writer.println("   @Override");
            writer.println("   public boolean connectReferences(WriteGraph graph, ParserElement element, java.util.Map<java.lang.String, ParserElement> map) throws DatabaseException {");
            writer.println("      " + this.getOntologyImport());
            writer.println("      boolean result = true;");
            for (IDReference ref : references) {
                writer.println("      {");
                writer.println("         Attribute a = element.getAttribute(\"" + ref.getIDSource().getName() + "\");");
                writer.println("         if (a != null) {");
                writer.println("            ParserElement refEle = map.get(a.value);");
                writer.println("            if (refEle != null) {");
                writer.println("               Resource ref = refEle.getData();");
                writer.println("               graph.claim(element.getData(), " + this.ontShort + name + "_" + ref.getReference().getName() + ", ref);");
                writer.println("            } else {");
                writer.println("               result = false;");
                writer.println("            }");
                writer.println("         }");
                writer.println("      }");
            }
            writer.println("      return result;");
            writer.println("   }");
            writer.println();
        }
    }

    private void writeUnknownChild(PrintWriter writer, String name, UnrecognizedChildElement unknownChildElement) {
        if (unknownChildElement == null) {
            return;
        }
        writer.println("   @Override");
        writer.println("   public void configureChild(WriteGraph graph, Deque<ParserElement> parents, ParserElement element, ParserElement child) throws DatabaseException {");
        writer.println("    " + unknownChildElement.getJavaMethod());
        writer.println("   }");
        writer.println();
    }

    @Override
    public String getBaseClass(SchemaObject.ObjectType type) {
        return "org.simantics.xml.sax.base.XMLElementNamedChildParserBase";
    }

    protected void createClassHeader(PrintWriter writer, boolean isList) {
        writer.println("package " + this.converter.getPluginName() + "." + this.elementPackageName + ";");
        writer.println();
        writer.println("import java.util.Deque;");
        writer.println("import org.simantics.databoard.Bindings;");
        writer.println("import org.simantics.db.Resource;");
        writer.println("import org.simantics.db.WriteGraph;");
        writer.println("import org.simantics.db.exception.DatabaseException;");
        writer.println("import org.simantics.xml.sax.base.Attribute;");
        writer.println("import org.simantics.xml.sax.base.ParserElement;");
        writer.println("import org.simantics.xml.sax.ontology.XMLResource;");
        if (!isList) {
            writer.println("import org.simantics.layer0.Layer0;");
        } else {
            writer.println("import java.util.Collections;");
            writer.println("import org.simantics.db.common.utils.ListUtils;");
        }
        writer.println();
    }
}

