/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.message.ILogger;
import org.simantics.xml.sax.base.Attribute;
import org.simantics.xml.sax.base.IDReferenceParser;
import org.simantics.xml.sax.base.ParserElement;
import org.simantics.xml.sax.base.UnrecognizedElementParser;
import org.simantics.xml.sax.base.XMLElementNamedChildParser;
import org.simantics.xml.sax.base.XMLElementParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler
implements Serializable {
    public static String PLUGIN_ID = "org.simantics.xml.sax.base";
    public static String XML_NAMESPACE_REF = "xmlns";
    private static final long serialVersionUID = 7360740940824360338L;
    private static final boolean debug = false;
    private ILogger logger;
    private WriteGraph graph;
    private Resource root;
    private String schemaURI;
    private Deque<ParserElement> current = new ArrayDeque<ParserElement>();
    private Map<String, XMLElementParser> parsers = new HashMap<String, XMLElementParser>();
    private Map<Class<? extends XMLElementParser>, XMLElementParser> namedParsers = new HashMap<Class<? extends XMLElementParser>, XMLElementParser>();
    private Map<String, XMLParser> subParsers = new HashMap<String, XMLParser>();
    private List<ParserElement> idReferenceElements = new ArrayList<ParserElement>();
    private Map<String, ParserElement> idMap = new HashMap<String, ParserElement>();
    StringBuilder charactersValue;

    public WriteGraph getGraph() {
        return this.graph;
    }

    public void setGraph(WriteGraph graph) {
        this.graph = graph;
        for (XMLParser p : this.subParsers.values()) {
            p.setGraph(graph);
        }
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void setSchemaURI(String schemaURI) {
        this.schemaURI = schemaURI;
    }

    public void add(XMLElementParser parser) {
        if (parser.getElementId() != null) {
            this.parsers.put(parser.getElementId(), parser);
        }
        this.namedParsers.put(parser.getClass(), parser);
    }

    public void add(XMLParser parser) {
        this.subParsers.put(parser.getSchemaURI(), parser);
    }

    private void loadElement(Deque<ParserElement> parents, ParserElement element) throws SAXException {
        XMLElementParser parser = null;
        ParserElement parent = null;
        if (parents.size() > 0) {
            parent = parents.peek();
            if (parent.getXMLParser() != null && parent.getXMLParser() != this) {
                element.setXMLParser(parent.getXMLParser());
                parent.getXMLParser().loadElement(parents, element);
                return;
            }
            if (parent.getElementParser() instanceof XMLElementNamedChildParser) {
                Class<? extends XMLElementParser> parserClass = ((XMLElementNamedChildParser)parent.getElementParser()).getParser(this.parsers, parent, element);
                if (parserClass != null && (parser = this.namedParsers.get(parserClass)) == null) {
                    try {
                        parser = parserClass.newInstance();
                        this.namedParsers.put(parserClass, parser);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        String err = "Error processing " + parserClass.getName() + " : element parsers must have accessible default constructor";
                        this.logger.log((IStatus)new Status(4, PLUGIN_ID, err));
                        throw new SAXException(err, e);
                    }
                }
            } else {
                parser = this.parsers.get(element.qName);
            }
        } else {
            parser = this.parsers.get(element.qName);
        }
        if (parser != null) {
            try {
                element.setData(parser.create(this.graph, element));
                if (parser instanceof IDReferenceParser) {
                    this.idReferenceElements.add(element);
                }
                element.setElementParser(parser);
            }
            catch (DatabaseException e) {
                throw new SAXException((Exception)((Object)e));
            }
        } else {
            Attribute schemaRef = element.getAttribute(XML_NAMESPACE_REF);
            if (schemaRef != null && this.subParsers.containsKey(schemaRef.value)) {
                XMLParser subParser = this.subParsers.get(schemaRef.value);
                subParser.loadElement(parents, element);
                element.setXMLParser(subParser);
            } else {
                if (parent == null && parents.size() > 0) {
                    parent = parents.peek();
                }
                String err = null;
                if (parent == null) {
                    err = "Unknown root element " + element.qName + ", cannot import the file";
                    throw new SAXException(err);
                }
                err = "Unknown element " + element.qName + ", parent " + (parent != null ? parent.getQName() : "None");
                this.logger.log((IStatus)new Status(4, PLUGIN_ID, err));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleElement(Deque<ParserElement> parents, ParserElement element) throws SAXException {
        parser = element.getElementParser();
        if (parser != null) {
            try {
                parser.configure(this.graph, parents, element);
                if (parents.size() > 0) {
                    parent = parents.peek();
                    if (parent.getElementParser() != null) {
                        if (!parent.getElementParser().connectChild(this.graph, parent, element) && !parser.connectParent(this.graph, parent, element)) {
                            err = "Did not connect element " + element.qName + ", parent " + (parent != null ? parent.getQName() : "None");
                            this.logger.log((IStatus)new Status(4, XMLParser.PLUGIN_ID, err));
                        }
                    } else {
                        err = "Did not connect element " + element.qName + ", parent " + (parent != null ? parent.getQName() : "None") + " was not imported";
                        this.logger.log((IStatus)new Status(4, XMLParser.PLUGIN_ID, err));
                    }
                }
                if ((id = parser.getID()) == null || (existing = this.idMap.put(id, element)) == null) ** GOTO lbl31
                v0 = useExt = existing.elementParser.idPriority() > element.elementParser.idPriority();
                if (useExt) {
                    this.idMap.put(id, existing);
                }
                err = "Duplicate XML element id: " + id + " for " + element.getQName() + " and " + existing.getQName() + ", using " + (useExt != false ? existing.getQName() : element.getQName());
                this.logger.log((IStatus)new Status(4, XMLParser.PLUGIN_ID, err));
            }
            catch (DatabaseException e) {
                throw new SAXException((Exception)e);
            }
        } else {
            parent = parents.peek();
            if (parent != null && (parser = parent.getElementParser()) != null && parser instanceof UnrecognizedElementParser) {
                try {
                    ((UnrecognizedElementParser)parser).configureChild(this.graph, parents, parent, element);
                }
                catch (DatabaseException e) {
                    throw new SAXException((Exception)e);
                }
            }
        }
lbl31:
        // 5 sources

        try {
            element.createLists(this.graph);
        }
        catch (DatabaseException e) {
            throw new SAXException((Exception)e);
        }
    }

    private void handleCharacters(ParserElement element, String string) throws SAXException {
        XMLElementParser parser = element.getElementParser();
        if (parser != null) {
            try {
                parser.configure(this.graph, element, string);
            }
            catch (DatabaseException e) {
                this.logger.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage()));
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    public void done() throws SAXException {
        try {
            for (ParserElement e : this.idReferenceElements) {
                IDReferenceParser parser = (IDReferenceParser)this.parsers.get(e.qName);
                if (parser.connectReferences(this.graph, e, this.idMap)) continue;
                String err = "Could not resolve ID references for " + e.getQName() + " " + e.getUri();
                this.logger.log((IStatus)new Status(4, PLUGIN_ID, err));
            }
        }
        catch (DatabaseException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public Resource getRoot() {
        return this.root;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        ParserElement e = new ParserElement(uri, localName, name, attributes);
        this.loadElement(this.current, e);
        this.current.push(e);
        this.charactersValue = new StringBuilder();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        ParserElement e = null;
        if (!this.current.isEmpty()) {
            e = this.current.pop();
        }
        if (e != null) {
            this.handleCharacters(e, this.charactersValue.toString());
            this.handleElement(this.current, e);
        }
        if (this.current.isEmpty()) {
            this.root = e.getData();
        }
        this.charactersValue = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.charactersValue.append(new String(ch, start, length));
    }

    public void parse(File file, ILogger logger) throws Exception {
        this.logger = logger;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser saxParser = spf.newSAXParser();
        XMLReader reader = saxParser.getXMLReader();
        reader.setContentHandler(this);
        reader.parse(new InputSource(new BufferedInputStream(new FileInputStream(file))));
        this.done();
    }
}

