/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.xml.sax.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.MapList;
import org.simantics.xml.sax.base.Attribute;
import org.simantics.xml.sax.base.XMLElementParser;
import org.simantics.xml.sax.base.XMLParser;
import org.xml.sax.Attributes;

public class ParserElement
implements Serializable {
    private static final long serialVersionUID = -5207502156942818875L;
    String uri;
    String localName;
    String qName;
    Map<String, Attribute> attributes;
    MapList<Resource, ParserElement> lists;
    XMLElementParser elementParser;
    XMLParser xmlParser;
    private Resource data;

    public ParserElement(String uri, String localName, String qName, Attributes attributes) {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        int attrCount = attributes.getLength();
        this.attributes = new HashMap<String, Attribute>(attrCount);
        int i = 0;
        while (i < attrCount) {
            this.attributes.put(attributes.getLocalName(i), new Attribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i)));
            ++i;
        }
    }

    public ParserElement(String uri, String localName, String qName, Collection<Attribute> attributes) {
        this.uri = uri;
        this.localName = localName;
        this.qName = qName;
        this.attributes = new HashMap<String, Attribute>(attributes.size());
        for (Attribute a : attributes) {
            this.attributes.put(a.localName, new Attribute(a.localName, a.qName, a.uri, a.value));
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getQName() {
        return this.qName;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributes.values();
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setData(Resource data) {
        this.data = data;
    }

    public Resource getData() {
        return this.data;
    }

    public void setElementParser(XMLElementParser parser) {
        this.elementParser = parser;
    }

    public XMLElementParser getElementParser() {
        return this.elementParser;
    }

    public void setXMLParser(XMLParser parser) {
        this.xmlParser = parser;
    }

    public XMLParser getXMLParser() {
        return this.xmlParser;
    }

    public void registerListChild(Resource predicate, ParserElement child) {
        if (this.lists == null) {
            this.lists = new MapList();
        }
        this.lists.add((Object)predicate, (Object)child);
    }

    public void createLists(WriteGraph graph) throws DatabaseException {
        if (this.lists == null) {
            return;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource predicate : this.lists.getKeys()) {
            ArrayList<Resource> children = new ArrayList<Resource>();
            for (ParserElement child : this.lists.getValues((Object)predicate)) {
                children.add(child.getData());
            }
            Resource list = ListUtils.create((WriteOnlyGraph)graph, (Resource)L0.List, (Resource)L0.List_Element, null, children);
            graph.claim(this.getData(), predicate, list);
        }
    }
}

