/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.interop.test.GraphChanges;
import org.simantics.interop.test.GraphComparator;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.ResourceReferenceTransfer;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ExceptionUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GraphComparatorViewer
extends ViewPart {
    private Session session;
    private Composite composite;
    private Label resourceText1;
    private Label resourceText2;
    private Text text1;
    private Text text2;
    private List<Resource> traversed = new ArrayList<Resource>();
    private List<Resource> tested = new ArrayList<Resource>();
    private List<Resource> strong = new ArrayList<Resource>();
    private List<Resource> nonTraversed = new ArrayList<Resource>();
    private List<Resource> nonTested = new ArrayList<Resource>();

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        this.session = SimanticsUI.getSession();
        Composite topComposite = new Composite(this.composite, 2048);
        topComposite.setLayout((Layout)new GridLayout(3, false));
        this.text1 = new Text(this.composite, 514);
        this.text2 = new Text(this.composite, 514);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)topComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.text1);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.text2);
        this.resourceText1 = this.createDropLabel(topComposite);
        this.resourceText2 = this.createDropLabel(topComposite);
        Button button = new Button(topComposite, 8);
        button.setText("Compare");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphComparatorViewer.this.compare();
            }
        });
        this.defaultConf();
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)new Action("Config"){

            public void run() {
                ConfigurationDialog dialog = new ConfigurationDialog(GraphComparatorViewer.this.getSite().getShell());
                dialog.open();
            }
        });
    }

    private void defaultConf() {
        this.traversed.clear();
        this.tested.clear();
        this.strong.clear();
        this.nonTested.clear();
        this.nonTraversed.clear();
        try {
            this.session.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    GraphComparatorViewer.this.traversed.add(l0.ConsistsOf);
                    GraphComparatorViewer.this.tested.add(l0.IsWeaklyRelatedTo);
                    GraphComparatorViewer.this.nonTraversed.add(l0.InstanceOf);
                }
            });
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    private void compare() {
        this.text1.setText("");
        this.text2.setText("");
        final Resource r1 = (Resource)this.resourceText1.getData();
        final Resource r2 = (Resource)this.resourceText2.getData();
        if (r1 == null || r2 == null) {
            if (r1 == null) {
                this.text1.setText("Missing input!");
            }
            if (r2 == null) {
                this.text2.setText("Missing input!");
            }
            return;
        }
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                String obj;
                String pre;
                String sub;
                GraphComparator comparator = new GraphComparator(r1, r2);
                comparator.addTested(GraphComparatorViewer.this.tested);
                comparator.addTraversed(GraphComparatorViewer.this.traversed);
                comparator.addNonTested(GraphComparatorViewer.this.nonTested);
                comparator.addNonTraversed(GraphComparatorViewer.this.nonTraversed);
                comparator.addStrong(GraphComparatorViewer.this.strong);
                comparator.test(graph);
                BijectionMap<Statement, Statement> map = comparator.getComparableStatements();
                HashMap<Statement, Integer> indices = new HashMap<Statement, Integer>();
                final StringBuilder sb1 = new StringBuilder();
                final StringBuilder sb2 = new StringBuilder();
                int index = 0;
                GraphChanges changes = comparator.getChanges();
                for (Pair<Statement, Statement> mod : changes.getModifications()) {
                    String obj2;
                    String pre2;
                    Statement s;
                    try {
                        s = (Statement)mod.first;
                        sub = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getSubject());
                        pre2 = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getPredicate());
                        obj2 = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getObject());
                        if (map.containsLeft((Object)s)) {
                            indices.put(s, ++index);
                            sb1.append("[" + index + "] ");
                        }
                        sb1.append(String.valueOf(sub) + " - " + pre2 + " - " + obj2);
                        sb1.append(" [" + s.getSubject().getResourceId() + " " + s.getPredicate().getResourceId() + " " + s.getObject().getResourceId() + "]");
                        sb1.append("\n");
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                    try {
                        s = (Statement)mod.second;
                        sub = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getSubject());
                        pre2 = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getPredicate());
                        obj2 = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getObject());
                        if (map.containsRight((Object)s)) {
                            index = (Integer)indices.get(map.getLeft((Object)s));
                            sb2.append("[" + index + "] ");
                        }
                        sb2.append(String.valueOf(sub) + " - " + pre2 + " - " + obj2);
                        sb2.append(" [" + s.getSubject().getResourceId() + " " + s.getPredicate().getResourceId() + " " + s.getObject().getResourceId() + "]");
                        sb2.append("\n");
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
                for (Statement s : changes.getDeletions()) {
                    try {
                        sub = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getSubject());
                        pre = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getPredicate());
                        obj = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getObject());
                        if (map.containsLeft((Object)s)) {
                            indices.put(s, ++index);
                            sb1.append("[" + index + "] ");
                        }
                        sb1.append(String.valueOf(sub) + " - " + pre + " - " + obj);
                        sb1.append(" [" + s.getSubject().getResourceId() + " " + s.getPredicate().getResourceId() + " " + s.getObject().getResourceId() + "]");
                        sb1.append("\n");
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
                for (Statement s : changes.getAdditions()) {
                    try {
                        sub = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getSubject());
                        pre = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getPredicate());
                        obj = NameUtils.getSafeName((ReadGraph)graph, (Resource)s.getObject());
                        if (map.containsRight((Object)s)) {
                            index = (Integer)indices.get(map.getLeft((Object)s));
                            sb2.append("[" + index + "] ");
                        }
                        sb2.append(String.valueOf(sub) + " - " + pre + " - " + obj);
                        sb2.append(" [" + s.getSubject().getResourceId() + " " + s.getPredicate().getResourceId() + " " + s.getObject().getResourceId() + "]");
                        sb2.append("\n");
                    }
                    catch (ValidationException e) {
                        e.printStackTrace();
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphComparatorViewer.this.text1.setText(sb1.toString());
                        GraphComparatorViewer.this.text2.setText(sb2.toString());
                    }
                });
            }
        });
    }

    public void setFocus() {
        this.composite.setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    public Label createDropLabel(Composite parent) {
        final Label label = new Label(parent, 2048);
        label.setAlignment(0x1000000);
        label.setText("Drag a resource here to examine it in this debugger!");
        label.setForeground(parent.getDisplay().getSystemColor(16));
        GridData data = new GridData(4, 128, true, false);
        data.heightHint = 16;
        label.setLayoutData((Object)data);
        DropTarget dropTarget = new DropTarget((Control)label, 5);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceReferenceTransfer.getInstance(), LocalObjectTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
            }

            public void dragLeave(DropTargetEvent event) {
                label.setBackground(null);
            }

            public void drop(DropTargetEvent event) {
                label.setBackground(null);
                ResourceArray[] data = this.parseEventData(event);
                if (data == null || data.length != 1) {
                    event.detail = 0;
                    return;
                }
                ResourceArray array = data[0];
                final Resource r = array.resources[array.resources.length - 1];
                label.setData((Object)r);
                try {
                    label.setText((String)GraphComparatorViewer.this.session.syncRequest((Read)new Read<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            return NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                        }
                    }));
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }

            private ResourceArray[] parseEventData(DropTargetEvent event) {
                ResourceArray[] ret;
                if (event.data instanceof String) {
                    try {
                        SerialisationSupport support = (SerialisationSupport)GraphComparatorViewer.this.session.getService(SerialisationSupport.class);
                        return ResourceTransferUtils.readStringTransferable((SerialisationSupport)support, (String)((String)event.data)).toResourceArrayArray();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                }
                if ((ret = ResourceAdaptionUtils.toResourceArrays((Object)event.data)).length > 0) {
                    return ret;
                }
                return null;
            }
        });
        return label;
    }

    private boolean saveConf(String filename) throws IOException, DatabaseException {
        File file = new File(filename);
        if (file.exists() ? !MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Saving compare configuration", (String)("Do you want to overwrite file'" + filename + "'?")) : !file.createNewFile()) {
            return false;
        }
        final PrintStream ps = new PrintStream(file);
        ps.println("<?xml version=\"1.0\"?>");
        ps.println("<compare>");
        this.session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (Resource r : GraphComparatorViewer.this.traversed) {
                    ps.println("<traversed uri=\"" + graph.getURI(r) + "\"/>");
                }
                for (Resource r : GraphComparatorViewer.this.tested) {
                    ps.println("<tested uri=\"" + graph.getURI(r) + "\"/>");
                }
                for (Resource r : GraphComparatorViewer.this.strong) {
                    ps.println("<strong uri=\"" + graph.getURI(r) + "\"/>");
                }
                for (Resource r : GraphComparatorViewer.this.nonTraversed) {
                    ps.println("<nontraversed uri=\"" + graph.getURI(r) + "\"/>");
                }
                for (Resource r : GraphComparatorViewer.this.nonTested) {
                    ps.println("<nontested uri=\"" + graph.getURI(r) + "\"/>");
                }
            }
        });
        ps.println("</compare>");
        ps.flush();
        ps.close();
        return true;
    }

    private void load(String filename) throws Exception {
        final ImportListener listener = new ImportListener();
        XMLParser parser = new XMLParser(listener);
        parser.parse(filename);
        if (listener.getNonTested().size() + listener.getNonTraversed().size() + listener.getStrong().size() + listener.getTested().size() + listener.getTraversed().size() == 0) {
            return;
        }
        this.session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphComparatorViewer.this.tested.clear();
                GraphComparatorViewer.this.traversed.clear();
                GraphComparatorViewer.this.strong.clear();
                GraphComparatorViewer.this.nonTested.clear();
                GraphComparatorViewer.this.nonTraversed.clear();
                for (String uri : listener.getTested()) {
                    GraphComparatorViewer.this.tested.add(graph.getResource(uri));
                }
                for (String uri : listener.getTraversed()) {
                    GraphComparatorViewer.this.traversed.add(graph.getResource(uri));
                }
                for (String uri : listener.getStrong()) {
                    GraphComparatorViewer.this.strong.add(graph.getResource(uri));
                }
                for (String uri : listener.getNonTested()) {
                    GraphComparatorViewer.this.nonTested.add(graph.getResource(uri));
                }
                for (String uri : listener.getNonTraversed()) {
                    GraphComparatorViewer.this.nonTraversed.add(graph.getResource(uri));
                }
            }
        });
    }

    private class AddAction
    extends Action {
        private Viewer viewer;
        private List<Object> list;

        public AddAction(Viewer viewer, List<Object> list) {
            super("Add");
            this.list = list;
            this.viewer = viewer;
        }

        public void run() {
            RelationChooseDialog dialog = new RelationChooseDialog(GraphComparatorViewer.this.getSite().getShell());
            if (dialog.open() == 0) {
                final String uri = dialog.getUri();
                try {
                    Resource res = (Resource)GraphComparatorViewer.this.session.syncRequest((Read)new Read<Resource>(){

                        public Resource perform(ReadGraph graph) throws DatabaseException {
                            try {
                                return graph.getResource(uri);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                    });
                    if (res != null) {
                        this.list.add(res);
                        this.viewer.refresh();
                    } else {
                        MessageDialog.openError((Shell)GraphComparatorViewer.this.getSite().getShell(), (String)"Error", (String)("Relation '" + uri + "' not found."));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class ConfigurationDialog
    extends Dialog {
        private ListViewer traversedViewer;
        private ListViewer testedViewer;
        private ListViewer strongViewer;
        private ListViewer nonTraversedViewer;
        private ListViewer nonTestedViewer;

        protected ConfigurationDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1025, "Load", false);
            this.createButton(parent, 1026, "Save", false);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == 1025) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String filename = dialog.open();
                if (filename == null) {
                    return;
                }
                try {
                    GraphComparatorViewer.this.load(filename);
                    this.traversedViewer.refresh();
                    this.testedViewer.refresh();
                    this.strongViewer.refresh();
                    this.nonTestedViewer.refresh();
                    this.nonTraversedViewer.refresh();
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot load file", (String)e1.getMessage());
                }
            } else if (buttonId == 1026) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.xml"});
                String filename = dialog.open();
                if (filename == null) {
                    return;
                }
                try {
                    GraphComparatorViewer.this.saveConf(filename);
                    if (!filename.endsWith("xml")) {
                        filename = String.valueOf(filename) + ".xml";
                    }
                }
                catch (FileNotFoundException e1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot save file", (String)e1.getMessage());
                }
                catch (IOException e1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot save file", (String)e1.getMessage());
                }
                catch (DatabaseException e1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Cannot save file", (String)e1.getMessage());
                }
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new FillLayout(512));
            Group group = new Group(composite, 0);
            group.setText("Traversed");
            group.setLayout((Layout)new FillLayout());
            this.traversedViewer = new ListViewer((Composite)group);
            group = new Group(composite, 0);
            group.setText("Tested");
            group.setLayout((Layout)new FillLayout());
            this.testedViewer = new ListViewer((Composite)group);
            group = new Group(composite, 0);
            group.setText("Strong");
            group.setLayout((Layout)new FillLayout());
            this.strongViewer = new ListViewer((Composite)group);
            group = new Group(composite, 0);
            group.setText("NonTraversed");
            group.setLayout((Layout)new FillLayout());
            this.nonTraversedViewer = new ListViewer((Composite)group);
            group = new Group(composite, 0);
            group.setText("NonTested");
            group.setLayout((Layout)new FillLayout());
            this.nonTestedViewer = new ListViewer((Composite)group);
            this.traversedViewer.setContentProvider((IContentProvider)new ResourceListContentProvider());
            this.traversedViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            this.testedViewer.setContentProvider((IContentProvider)new ResourceListContentProvider());
            this.testedViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            this.strongViewer.setContentProvider((IContentProvider)new ResourceListContentProvider());
            this.strongViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            this.nonTraversedViewer.setContentProvider((IContentProvider)new ResourceListContentProvider());
            this.nonTraversedViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            this.nonTestedViewer.setContentProvider((IContentProvider)new ResourceListContentProvider());
            this.nonTestedViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            MenuManager strongManager = new MenuManager();
            strongManager.setRemoveAllWhenShown(true);
            strongManager.addMenuListener((IMenuListener)new ListPopupListener(this.strongViewer));
            this.strongViewer.getControl().setMenu(strongManager.createContextMenu(this.strongViewer.getControl()));
            MenuManager nonTestedManager = new MenuManager();
            nonTestedManager.setRemoveAllWhenShown(true);
            nonTestedManager.addMenuListener((IMenuListener)new ListPopupListener(this.nonTestedViewer));
            this.nonTestedViewer.getControl().setMenu(nonTestedManager.createContextMenu(this.nonTestedViewer.getControl()));
            MenuManager nonTraversedManager = new MenuManager();
            nonTraversedManager.setRemoveAllWhenShown(true);
            nonTraversedManager.addMenuListener((IMenuListener)new ListPopupListener(this.nonTraversedViewer));
            this.nonTraversedViewer.getControl().setMenu(nonTraversedManager.createContextMenu(this.nonTraversedViewer.getControl()));
            MenuManager testedManager = new MenuManager();
            testedManager.setRemoveAllWhenShown(true);
            testedManager.addMenuListener((IMenuListener)new ListPopupListener(this.testedViewer));
            this.testedViewer.getControl().setMenu(testedManager.createContextMenu(this.testedViewer.getControl()));
            MenuManager traversedManager = new MenuManager();
            traversedManager.setRemoveAllWhenShown(true);
            traversedManager.addMenuListener((IMenuListener)new ListPopupListener(this.traversedViewer));
            this.traversedViewer.getControl().setMenu(traversedManager.createContextMenu(this.traversedViewer.getControl()));
            this.traversedViewer.setInput((Object)GraphComparatorViewer.this.traversed);
            this.testedViewer.setInput((Object)GraphComparatorViewer.this.tested);
            this.strongViewer.setInput((Object)GraphComparatorViewer.this.strong);
            this.nonTestedViewer.setInput((Object)GraphComparatorViewer.this.nonTested);
            this.nonTraversedViewer.setInput((Object)GraphComparatorViewer.this.nonTraversed);
            return composite;
        }
    }

    private class DeleteAction
    extends Action {
        private Viewer viewer;
        private List<?> list;
        private Object obj;

        public DeleteAction(Viewer viewer, List<?> list, Object obj) {
            super("Delete");
            this.list = list;
            this.obj = obj;
            this.viewer = viewer;
        }

        public void run() {
            this.list.remove(this.obj);
            this.viewer.refresh();
        }
    }

    public static class ImportListener {
        private Collection<String> traversed = new ArrayList<String>();
        private Collection<String> tested = new ArrayList<String>();
        private Collection<String> strong = new ArrayList<String>();
        private Collection<String> nonTraversed = new ArrayList<String>();
        private Collection<String> nonTested = new ArrayList<String>();

        public void done() {
        }

        public void addTraversed(String uri) {
            this.traversed.add(uri);
        }

        public void addTested(String uri) {
            this.tested.add(uri);
        }

        public void addStrong(String uri) {
            this.strong.add(uri);
        }

        public void addNonTraversed(String uri) {
            this.nonTraversed.add(uri);
        }

        public void addNonTested(String uri) {
            this.nonTested.add(uri);
        }

        public Collection<String> getTraversed() {
            return this.traversed;
        }

        public Collection<String> getNonTested() {
            return this.nonTested;
        }

        public Collection<String> getNonTraversed() {
            return this.nonTraversed;
        }

        public Collection<String> getStrong() {
            return this.strong;
        }

        public Collection<String> getTested() {
            return this.tested;
        }
    }

    private class ListPopupListener
    implements IMenuListener {
        private ListViewer viewer;

        public ListPopupListener(ListViewer viewer) {
            this.viewer = viewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
            List list = (List)this.viewer.getInput();
            manager.add((IAction)new AddAction((Viewer)this.viewer, list));
            if (!s.isEmpty()) {
                Object element = s.getFirstElement();
                manager.add((IAction)new DeleteAction((Viewer)this.viewer, list, element));
            }
        }
    }

    private class RelationChooseDialog
    extends Dialog {
        private String uri;
        private Text text;

        public RelationChooseDialog(IShellProvider parentShell) {
            super(parentShell);
            this.uri = null;
        }

        public RelationChooseDialog(Shell parentShell) {
            super(parentShell);
            this.uri = null;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label(composite, 0);
            label.setText("URI:");
            this.text = new Text(composite, 2052);
            this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            return composite;
        }

        protected void okPressed() {
            this.uri = this.text.getText();
            super.okPressed();
        }

        public String getUri() {
            return this.uri;
        }
    }

    private class ResourceLabelProvider
    extends LabelProvider {
        private ResourceLabelProvider() {
        }

        public String getText(Object element) {
            final Resource res = (Resource)element;
            try {
                return (String)GraphComparatorViewer.this.session.syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        return NameUtils.getSafeName((ReadGraph)graph, (Resource)res);
                    }
                });
            }
            catch (DatabaseException e) {
                return "Error: " + e.getMessage();
            }
        }
    }

    private class ResourceListContentProvider
    implements IStructuredContentProvider {
        private ResourceListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List list = (List)inputElement;
            return list.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public static class XMLParser {
        private ImportListener listener;

        public XMLParser(ImportListener listener) {
            this.listener = listener;
        }

        public void parse(String filename) throws Exception {
            ParserBean p = new ParserBean();
            p.parse(filename);
        }

        private void handleElement(Stack<Element> parents, Element element) throws SAXException {
            String name = element.qName;
            if (name.equals("traversed")) {
                for (Attribute a : element.attributes) {
                    String propertyName = a.localName;
                    String value = a.value;
                    if (!propertyName.equals("uri")) continue;
                    this.listener.addTraversed(value);
                }
            } else if (name.equals("tested")) {
                for (Attribute a : element.attributes) {
                    String propertyName = a.localName;
                    String value = a.value;
                    if (!propertyName.equals("uri")) continue;
                    this.listener.addTested(value);
                }
            } else if (name.equals("strong")) {
                for (Attribute a : element.attributes) {
                    String propertyName = a.localName;
                    String value = a.value;
                    if (!propertyName.equals("uri")) continue;
                    this.listener.addStrong(value);
                }
            } else if (name.equals("nontraversed")) {
                for (Attribute a : element.attributes) {
                    String propertyName = a.localName;
                    String value = a.value;
                    if (!propertyName.equals("uri")) continue;
                    this.listener.addNonTraversed(value);
                }
            } else if (name.equals("nontested")) {
                for (Attribute a : element.attributes) {
                    String propertyName = a.localName;
                    String value = a.value;
                    if (!propertyName.equals("uri")) continue;
                    this.listener.addNonTested(value);
                }
            } else if (!name.equals("compare")) {
                throw new SAXException("Unknown element '" + name + "'. The file does not contain ExtIO configuration.");
            }
        }

        public class Attribute {
            public String localName;
            public String qName;
            public String uri;
            public String value;

            public Attribute(String localName, String qName, String uri, String value) {
                this.localName = localName;
                this.qName = qName;
                this.uri = uri;
                this.value = value;
            }
        }

        public class Element
        implements Serializable {
            private static final long serialVersionUID = -5207502156942818875L;
            String uri;
            String localName;
            String qName;
            String value = null;
            List<Attribute> attributes = new ArrayList<Attribute>();

            public Element(String uri, String localName, String qName, Attributes attributes) {
                this.uri = uri;
                this.localName = localName;
                this.qName = qName;
                int i = 0;
                while (i < attributes.getLength()) {
                    this.attributes.add(new Attribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i)));
                    ++i;
                }
            }

            public String getUri() {
                return this.uri;
            }

            public String getLocalName() {
                return this.localName;
            }

            public String getQName() {
                return this.qName;
            }

            public String getValue() {
                return this.value;
            }

            public List<Attribute> getAttributes() {
                return this.attributes;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }

        public class ParserBean
        extends DefaultHandler
        implements Serializable {
            private static final long serialVersionUID = -4995836637014958966L;
            private Stack<Element> current = new Stack();
            private Stack<String> texts = new Stack();

            public void parse(String filename) throws Exception {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser saxParser = spf.newSAXParser();
                XMLReader reader = saxParser.getXMLReader();
                FileReader file = new FileReader(filename);
                reader.setContentHandler(this);
                reader.parse(new InputSource(file));
                XMLParser.this.listener.done();
            }

            @Override
            public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                this.current.push(new Element(uri, localName, name, attributes));
                this.texts.push(new String());
            }

            @Override
            public void endElement(String uri, String localName, String name) throws SAXException {
                Element e = null;
                String text = null;
                if (!this.current.empty()) {
                    e = this.current.pop();
                    text = this.texts.pop();
                }
                if (e != null) {
                    e.setValue(text.trim());
                }
                if (e != null) {
                    XMLParser.this.handleElement(this.current, e);
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if (!this.current.empty()) {
                    String text = this.texts.pop();
                    String value = new String(ch, start, length);
                    text = String.valueOf(text) + value;
                    this.texts.push(text);
                }
            }
        }
    }
}

