/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.mapping;

import java.util.Properties;
import org.simantics.diagram.LogManager;

public class Logger {
    public static final boolean ECHO = false;
    public static final boolean TRACE = false;
    public static final Properties defaultProperties = new Properties();
    private static LogManager defaultLogManager;
    private static final Logger defaultErrorLogger;
    private org.apache.log4j.Logger logger;

    static {
        defaultProperties.put("log4j.rootCategory", "INFO, default");
        defaultProperties.put("log4j.appender.default", "org.apache.log4j.FileAppender");
        defaultProperties.put("log4j.appender.default.File", "mapping.log");
        defaultProperties.put("log4j.appender.default.append", "false");
        defaultProperties.put("log4j.appender.default.layout", "org.apache.log4j.PatternLayout");
        defaultProperties.put("log4j.appender.default.layout.ConversionPattern", "%-6r %-5p - %m%n");
        defaultLogManager = new LogManager(defaultProperties);
        defaultErrorLogger = new Logger(LogManager.class);
    }

    Logger(Class<?> clazz) {
        this.logger = defaultLogManager.getLogger(clazz);
    }

    public void logTrace(String message, Throwable exception) {
        this.logger.trace((Object)message, exception);
    }

    public void logInfo(String message, Throwable exception) {
        this.logger.info((Object)message, exception);
    }

    public void logWarning(String message, Throwable exception) {
        this.logger.warn((Object)message, exception);
    }

    public void logError(String message, Throwable exception) {
        this.logger.error((Object)message, exception);
    }

    public static Logger getDefault() {
        return defaultErrorLogger;
    }

    public static LogManager getDefaultLogManager() {
        return defaultLogManager;
    }

    public static void setDefaultThreshold(String level) {
        Logger.getDefaultLogManager().setThreshold(level);
    }

    public static void defaultLogError(Throwable exception) {
        Logger.getDefault().logError(exception.getLocalizedMessage(), exception);
    }

    public static void defaultLogError(String message) {
        Logger.getDefault().logError(message, null);
    }

    public static void defaultLogError(String message, Throwable exception) {
        Logger.getDefault().logError(message, exception);
    }

    public static void defaultLogInfo(String message) {
        Logger.getDefault().logInfo(message, null);
    }

    public static void defaultLogWarning(String message) {
        Logger.getDefault().logWarning(message, null);
    }

    public static void defaultLogTrace(String message) {
        Logger.getDefault().logTrace(message, null);
    }
}

