package org.simantics.workbench.search;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.scl.runtime.function.Function5;

public class SearchEngine {

	private String id;
	private String name;
	private Function5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> searchFunction;
	private Set<String> supportedParams = new HashSet<String>();
	private boolean enabledByDefault;
	
	public SearchEngine(String id, Function5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> searchFunction, boolean enabledByDefault) {
		this(id, id, searchFunction, enabledByDefault);
	}
	
	public SearchEngine(String id, String name, Function5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> searchFunction, boolean enabledByDefault) {
		this.id = id;
		this.name = name;
		this.searchFunction = searchFunction;
		this.enabledByDefault = enabledByDefault;
	}
	
	public String getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public Function5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> getSearchFunction() {
		return searchFunction;
	}

	public boolean isEnabledByDefault() {
		return enabledByDefault;
	}

	@Override
	public int hashCode() {
		return id.hashCode();
	}

	public void addSupportedParam(String param) {
		this.supportedParams.add(param);
	}
	
	public Set<String> getSupportedParams() {
		return supportedParams;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (obj.getClass() != getClass())
			return false;
		SearchEngine other = (SearchEngine)obj;
		return id.equals(other.id);
	}
	
	@Override
	public String toString() {
		return name;
	}
}
