package org.simantics.workbench.search;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;


/**
 * @author Tuukka Lehtonen
 */
public class SearchData {

    int resultNumber;

    String dataUrl;
    File dataDirectory;
    SearchQuery query;
    NamedResource model;
    SearchEngine searchEngine;
    SearchResult results;
    Collection<SearchEngine> searchEngines;
    
    int resultCount;
    int maxResults;

    public int getResultNumber() {
        return resultNumber;
    }

    public String getDataUrl() {
        return dataUrl;
    }

    public File getDataDirectory() {
        return dataDirectory;
    }

    public SearchQuery getQuery() {
        return query;
    }
    
    public Collection<SearchEngine> getSearchEngines() {
		return searchEngines;
	}
    
    public Set<String> getAllSearchParams() {
    	Set<String> params = new HashSet<String>();
    	for (SearchEngine engine : searchEngines)
    		params.addAll(engine.getSupportedParams());
    	return params;
    }

    public NamedResource getModel() {
        return model;
    }

    public SearchResult getResults() {
        return results;
    }

    public int getResultCount() {
        return results.rows.size();
    }
    
    public int getResultTotalCount() {
        return resultCount;
    }

    public int getMaxResults() {
        return maxResults;
    }
    
    public SearchEngine getSearchEngine() {
		return searchEngine;
	}

    public SearchData clone() {
        SearchData data = new SearchData();
        data.resultNumber = resultNumber;
        data.dataUrl = dataUrl;
        data.dataDirectory = dataDirectory;
        data.query = query;
        data.model = model;
        data.results = results;
        data.maxResults = maxResults;
        data.resultCount = resultCount;
        data.searchEngine = searchEngine;
        data.searchEngines = searchEngines;
        return data;
    }
    
    
}
