package org.simantics.structural.synchronization.utils;

import java.util.Collection;

import org.simantics.structural.synchronization.protocol.ChildInfo;
import org.simantics.structural.synchronization.protocol.Connection;
import org.simantics.structural.synchronization.protocol.SerializedVariable;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.simantics.structural.synchronization.protocol.SynchronizationException;

public class DiagnosticSynchronizationEventHandler implements SynchronizationEventHandler {

    int indentation;

    @Override
    public void beginSynchronization() {
    }

    @Override
    public void endSynchronization() {
    }

    @Override
    public void beginComponent(String name, String typeId,
            Collection<SerializedVariable> properties,
            Collection<Connection> connections, Collection<ChildInfo> children)
                    throws SynchronizationException {
        for(int i=0;i<indentation;++i)
            System.out.print("  ");
        System.out.print(name);
        if(typeId != null)
            System.out.print(" :: " + typeId);
        System.out.println();
        for(SerializedVariable var : properties) {
            for(int i=0;i<=indentation;++i)
                System.out.print("  ");
            System.out.println(SerializedVariable.print(var, indentation*2+2));
        }
        for(Connection connection : connections) {
            for(int i=0;i<=indentation;++i)
                System.out.print("  ");
            System.out.println(connection);
        }
        if(!children.isEmpty()) {
            for(int i=0;i<=indentation;++i)
                System.out.print("  ");
            System.out.print("Children ");
            if(children != null)
                System.out.println(children);
        }
        ++indentation;
    }

    @Override
    public void endComponent() {
        --indentation;
    }

    @Override
    public void beginType(String id, Collection<SerializedVariable> properties) {
        System.out.println("--- Type " + id + " --------------------------------");
        for(SerializedVariable var : properties)
            System.out.println(SerializedVariable.print(var, 2));
    }

    @Override
    public void endType() {
        System.out.println("----------------------------------------------------");
    }

    @Override
    public void reportProblem(String description) {
        System.err.println(description);
    }

    @Override
    public void reportProblem(String description, Exception e) {
        System.err.println(description);
        e.printStackTrace();
    }

}
