package org.simantics.structural.synchronization.protocol;

import java.util.Collection;

/**
 * Communicates synchronization events from the synchronizer
 * browsing variable structure to the simulator.
 * 
 * TODO:
 * - which properties available in the variable are sent (based on classification)
 * - what to do when resource ids change (export/import)
 */
public interface SynchronizationEventHandler {
    
    
    /**
     * Called at the beginning of synchronization. All other
     * methods must be called between beginSynchronization/endSynchronization pair.
     */
    void beginSynchronization();
    
    /**
     * Called at the end of synchronization.
     */
    void endSynchronization();
    
    /**
     * Describes a component
     */
    void beginComponent(
            String name,
            String typeId,
            Collection<SerializedVariable> properties,
            Collection<Connection> connections,
            Collection<ChildInfo> children) throws SynchronizationException;
    
    void endComponent();

    /*
     * TODO: maybe we require that whenever a type is updated all its instances are also updated
     */
    void beginType(
            String id,
            Collection<SerializedVariable> properties) throws SynchronizationException;
    void endType();

    void reportProblem(String description);

    void reportProblem(String description, Exception e);
    
    /**
     * Called when an error happens during synchronization that prevents its continuation.
     * Returns true, if the handler was able to fix the state of the mapping. If false,
     * the current state is unusable and should be discarded.
     */
    //boolean cleanUpAfterSynchronizationFailure();
}
