package org.simantics.help.core;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.simantics.help.core"; //$NON-NLS-1$

	public static final String HTML_FOLDER = "html";
	
	// The shared instance
	private static Activator plugin;
	private static Path directory;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
        Bundle bundle = context.getBundle();
        IPath path = Platform.getStateLocation(bundle);
        Path p = Paths.get(path.toOSString());
        directory = p.resolve(HTML_FOLDER);
        if (!Files.exists(directory))
            Files.createDirectories(directory);
        
        // Ensure that style.css is inside the html directory
        Path css = directory.resolve("style.css");
        if (!Files.exists(css)) {
            Files.createFile(css);
            URL url = bundle.getEntry("css/style.css");
            Files.copy(url.openStream(), css, StandardCopyOption.REPLACE_EXISTING);
        }
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}
	
    public static Path getHtmlDirectory() {
        return directory;
    }

}
