package org.simantics.graph.tests.diff;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;

public class TestDiff {
	
	public static TransferableGraph1 load(String name) throws IOException {
		InputStream stream = TestDiff.class.getResourceAsStream(name);
		Bindings.getSerializerUnchecked(Datatype.class).skip(stream);
		TransferableGraph1 result = (TransferableGraph1)TransferableGraph1.SERIALIZER.deserialize(stream);
		stream.close();
		return result;
	}
	
	public static int[] randomPermutation(int size) {
		Random rand = new Random();
		int[] permutation = new int[size];
		for(int i=0;i<size;++i)
			permutation[i] = i;
		for(int i=size-1;i>0;--i) {
			int j = rand.nextInt(i+1);
			int temp = permutation[i];
			permutation[i] = permutation[j];
			permutation[j] = temp;
		}
		return permutation;
	}
	
	public static void shuffle(TransferableGraph1 tg) {
		int[] permutation = randomPermutation(tg.resourceCount);
		
		{
			int[] statements = tg.statements;
			for(int i=0;i<statements.length;++i) {
				int r = statements[i];
				if(r >= 0)
					statements[i] = permutation[r];				
			}
		}
		
		for(Identity id : tg.identities) {
			id.resource = permutation[id.resource];
			if(id.definition instanceof External) {
				External def = (External)id.definition;
				def.parent = permutation[def.parent];
			}
			else if(id.definition instanceof Internal) {
				Internal def = (Internal)id.definition;
				def.parent = permutation[def.parent];
			}
			else if(id.definition instanceof Optional) {
				Optional def = (Optional)id.definition;
				def.parent = permutation[def.parent];
			}
		}
		
		for(Value value : tg.values) {
			value.resource = permutation[value.resource];
		}
	}
	
	public static void main(String[] args) throws Exception {
		TransferableGraph1 graphOld = load("layer0.tg");
		TransferableGraph1 graphNew = load("layer0.tg");
		shuffle(graphNew);
		long begin = System.nanoTime();
		Diff diff = new Diff(graphOld, graphNew);
		/*TransferableGraphDelta1 result =*/ diff.diff();
		long end = System.nanoTime();

		System.out.println("Total time: " + (end - begin)*1e-6 + "ms");
		//result.print();
	}
	
}
