package org.simantics.graph.store;

import gnu.trove.map.hash.TIntIntHashMap;

import java.util.concurrent.Callable;

public interface IStore {
	void map(TIntIntHashMap map);
	
	static class MapTask implements Callable<Object> {
		IStore store;
		TIntIntHashMap map;		
		
		public MapTask(IStore store, TIntIntHashMap map) {
			this.store = store;
			this.map = map;
		}

		@Override
		public Object call() throws Exception {
			store.map(map);
			return null;
		}		
	}
}
