package org.simantics.document.linking.report.templates;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.report.Document.TextSize;
import org.simantics.document.linking.report.TableColumn.Alignment;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.URLItem;
import org.simantics.document.linking.report.evaluator.AlignmentHint;
import org.simantics.document.linking.report.evaluator.Date;
import org.simantics.document.linking.report.evaluator.EvaluatorNode;
import org.simantics.document.linking.report.evaluator.Lines;
import org.simantics.document.linking.report.evaluator.Or;
import org.simantics.document.linking.report.evaluator.TextSizeHint;
import org.simantics.document.linking.report.evaluator.Variable;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;
import org.simantics.document.linking.report.templates.custom.EvaluatorCustomizableContent;


public abstract  class DocumentWriter<T> extends TableReportWriter<T> implements CustomizableContentProvider{
	
	Map<String, CustomizableContent> content = new HashMap<String, CustomizableContent>();
	ReadGraph graph;
	DocumentResource doc;
	Document document;
	Map<Object, Object> context;
	
	public DocumentWriter() {
		setDefaultContent(null);
	}
	
	@Override
	public void start(ReadGraph graph, Resource model, Document writer,
			Map<Object, Object> context) throws Exception {
		this.graph = graph;
		this.doc = DocumentResource.getInstance(graph);
		this.context = context;
		this.document = writer;
	}
	
	
	@Override
	public CustomizableContent getContent(String id) {
		return content.get(id);
	}
	
	@Override
	public void setContent(String id, CustomizableContent content) {
		this.content.put(id, content);
	}
	
	@Override
	public void setDefaultContent(String id) {
		if ("Document".equals(id) || id == null) {
			EvaluatorCustomizableContent c = new EvaluatorCustomizableContent("Document format");
			Or item = new Or();
			item.addChild(new Variable("#HasLabel"));
			item.addChild(new Variable("#HasName"));
			c.setItem(item);
			c.setSupportStyles(false);
			c.setSupportMultiline(true);
			content.put("Document", c);
		} 
		if ("Title".equals(id) || id == null) {
			EvaluatorCustomizableContent e = new EvaluatorCustomizableContent("Document Title");
			EvaluatorNode lines = new Lines();
			Or nameOr = new Or();
			nameOr.createChild(Variable.class).setVariableRef("#HasLabel");
			nameOr.createChild(Variable.class).setVariableRef("#HasName");
			lines.createChild(TextSizeHint.class).setTextSize(TextSize.HUGE).createChild(AlignmentHint.class).setAlignment(Alignment.CENTER).addChild(nameOr.copy());
			lines.createChild(TextSizeHint.class).setTextSize(TextSize.HUGE).createChild(AlignmentHint.class).setAlignment(Alignment.CENTER).createChild(Variable.class).setVariableRef("DocumentName");
			lines.createChild(TextSizeHint.class).setTextSize(TextSize.LARGE).createChild(AlignmentHint.class).setAlignment(Alignment.CENTER).createChild(Date.class);
			e.setItem(lines);
			e.setSupportStyles(true);
			e.setSupportMultiline(true);
			content.put("Title", e);
		}
	}
	
	@Override
	public Collection<String> getContentIds() {
		return content.keySet();
	}
	
	protected TextItem getDocumentItem(Resource document) throws Exception{
		TextItem item;
		if (graph.isInstanceOf(document, doc.UrlDocument)) {
			item = this.document.newItem(URLItem.class);
			((URLItem)item).setURL(new URL((String)graph.getRelatedValue(document, doc.HasUrl)));
		} else {
			item = this.document.newItem(TextItem.class);
		}
		item.setText(getContent("Document").getContent(graph, document,context));
		return item;
	}
	
	protected TextItem getNonExistingDocumentItem() throws Exception{
		TextItem item = this.document.newItem(TextItem.class);
		item.setText("[DOCUMENT DOES NOT EXIST]");
		return item;
	}


}
