package org.simantics.document.linking.report.pdf;

import java.util.List;

import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.Document.TextSize;
import org.simantics.document.linking.report.TableColumn.Alignment;


public class PDFTitlePage extends DocumentTitlePage implements PDFElement {
	
	PDFDocument document;
	PDFPage page;
	public PDFTitlePage(PDFDocument writer) {
		this.document = writer;
	}
	
	@Override
	public PDFPage getPage() {
		return page;
	}
	
	@Override
	public void writeTitle(List<DocumentLine> titleLines) throws Exception {
		Alignment alignment = (Alignment)titleLines.get(0).getHints().get(Alignment.class);
		if (alignment == null)
			alignment = Alignment.CENTER;
		TextSize textSize = (TextSize)titleLines.get(0).getHints().get(TextSize.class);
		if (textSize == null)
			textSize = TextSize.HUGE;
		
		document.nextPage();
		this.page = document.contentStream.getCurrentPage();
		Table table = document.newElement(Table.class);
		table.addColumn("Names", 1.0).setAlignment(alignment);
		table.setLinesVisible(false);
		table.setHeaderVisible(false);
		table.setTextSize(textSize);
		int lines = (document.contentStream.getAvailableLines()-3)/2;
		for (int i = 0; i < lines; i++)
			table.writeRow("");
		for (DocumentLine line : titleLines) {
			TextSize s = (TextSize)line.getHints().get(TextSize.class);
			if (s != null)
				textSize = s;
			table.setTextSize(textSize);
			table.writeRow(line.getLine());
		}
		table.setTextSize(TextSize.SMALL);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		document.nextPage();
		
	}
	
	

}
