package org.simantics.document.linking.report.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

@OrderedSetType(DocumentLink.URIs.EvaluatorTree_Path)
public class Path extends EvaluatorNode implements StringEditableNode{
	
	String separator;
	
	public Path() {
		separator = "/";
	}
	
	public Path(String separator) {
		this.separator = separator;
	}
	
	@Override
	public String toString() {
		return "path " + "(" + separator +")" ;
	}
	
	@Override
	public String setValue(String value) {
		separator = value;
		return null;
	}
	
	@RelatedSetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	public void _setValue(String value) {
		separator = value;
	}
	
	@RelatedGetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public String getValue() {
		return separator;
	}
	
	@Override
	public String getValue(ReadGraph graph, Variable variable,
			Map<Object, Object> context) throws DatabaseException {
		Resource model = (Resource)context.get("model");
		String text = "";
		Variable parent = variable.getParent(graph);
		while (parent != null) {
			text = children.get(0).getValue(graph, parent, context) + separator + text;
			parent = parent.getParent(graph);
			if (model.equals(parent.getRepresents(graph)))
				parent = null;
		}
		if (text.length() == 0)
			return null;
		return text.substring(0,text.length()-separator.length());
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph, Variable variable,
			Map<Object, Object> context) throws DatabaseException {
		List<DocumentLine> result = new ArrayList<DocumentLine>();
		Resource model = (Resource)context.get("model");
		for (int i = 0 ; i < children.size(); i++) {
			Variable parent = variable.getParent(graph);
			while (parent != null) {
				List<DocumentLine> list = children.get(i).getLines(graph, parent, context);
				for (int j = 0; j < list.size(); j++) {
					DocumentLine line = list.get(j); 
					if (j <= result.size()) {
						result.add(line);
					} else {
						DocumentLine extLine = result.get(j);
						String combined = line.getLine() + separator + extLine.getLine();
						Map<Object,Object> combinedSet = new HashMap<Object, Object>();
						combinedSet.putAll(extLine.getHints());
						combinedSet.putAll(line.getHints());
						
						result.set(j, new DocumentLine(combined,combinedSet));
					}
				}
				parent = parent.getParent(graph);
				if (model.equals(parent.getRepresents(graph)))
					parent = null;
			}
		}
		return result;
	}
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/folder.png");
	}
	
	@Override
	public EvaluatorItem copy() {
		Path path = new Path();
		return path;
	}
	
	@Override
	public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
		if (add && children.size() > 0)
			return Collections.emptyList();
		return super.getPossibleChildren(add);
	}
	
	@Override
	public boolean acceptChild(EvaluatorItem item) {
		return children.size() == 0;
	}
	
	@Override
	public boolean acceptChild(int index, EvaluatorItem item) {
		return children.size() == 0;
	}

}
