package org.simantics.document.linking.report.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.objmap.graph.annotations.OrderedSetType;

/**
 * Checks that the first size does not return null or "false". 
 * Depending on results evaluates the second child or the third (if it exists).
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
@OrderedSetType(DocumentLink.URIs.EvaluatorTree_If)
public class If extends EvaluatorNode{

	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		if (children.size() > 3)
			throw new DatabaseException("If node has more than 3 children.");
		
		String ifVal = children.get(0).getValue(graph, variable, context);
		if (ifVal != null && ifVal.length() > 0 && !Boolean.FALSE.toString().equals(ifVal)) {
			return children.get(1).getValue(graph, variable, context);
		} else if (children.size() == 3) {
			return children.get(2).getValue(graph, variable, context);
		}
		return null;
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph,	Variable variable, Map<Object, Object> context) throws DatabaseException {
		if (children.size() > 3)
			throw new DatabaseException("If node has more than 3 children.");
		String ifVal = children.get(0).getValue(graph, variable, context);
		if (ifVal != null && ifVal.length() > 0 && !Boolean.FALSE.toString().equals(ifVal)) {
			return children.get(1).getLines(graph, variable, context);
		} else if (children.size() == 3) {
			return children.get(2).getLines(graph, variable, context);
		}
		return Collections.emptyList();
	}
	

	@Override
	public String toString() {
		return "if";
	}
	
	@Override
	public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
		if (add && children.size() == 3)
			return Collections.emptyList();
		return super.getPossibleChildren(add);
	}
	
	@Override
	public EvaluatorItem copy() {
		If node = new If();
		copyChildren(node);
		return node;
		
	}
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/help.png");
	}
	
	@Override
	public boolean acceptChild(EvaluatorItem item) {
		return children.size() < 3;
	}
	
	@Override
	public boolean acceptChild(int index, EvaluatorItem item) {
		return children.size() < 3;
	}

}
