package org.simantics.document.linking.report.evaluator;

import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.objmap.graph.annotations.GraphType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;


@GraphType(DocumentLink.URIs.EvaluatorTree_Constant)
public class Constant extends EvaluatorLeaf implements StringEditableNode{
	
	private String string;
	
	
	public Constant() {
		string = "text";
	}
	
	public Constant(String text) {
		if (text == null)
			throw new NullPointerException("Text is null");
		string = text;
	}
	
	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		return string;
	}
	
	@Override
	public String toString() {
		return "\"" + string + "\"";
	}
	
	@RelatedGetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public String getValue() {
		return string;
	}
	
	@Override
	public String setValue(String value) {
		string = value;
		return null;
	}
	
	@RelatedSetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	public void _setValue(String value) {
		string = value;
	}
	
	@Override
	public EvaluatorItem copy() {
		return new Constant(string);
	}
	
	
	@Override
	public ImageDescriptor getImage() {
		return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/textfield.png");
	}

}
