package org.simantics.document.linking.report;

/**
 * Interface for creating documents.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public interface Document {
	
	public static String TOC = "toc";
	
	public enum TextSize {TINY,SMALL,MEDIUM,LARGE,HUGE};

	/**
	 * Creates a new element of given class
	 * @param cls
	 * @return
	 * @throws Exception
	 */
	public <T extends DocumentElement> T newElement(Class<T> cls,String... options) throws Exception;
	
	/**
	 * Creates a new element of given class, copies parameters from previous element of the same class.
	 * @param cls
	 * @return
	 * @throws Exception
	 */
	public <T extends DocumentElement> T nextElement(Class<T> cls, String... options) throws Exception;
	
	/**
	 * Returns last element of given class.
	 * @param cls
	 * @return
	 */
	public <T extends DocumentElement> T getCurrentElement(Class<T> cls);
	
	
	/**
	 * Creates a new item of given class
	 * @param cls
	 * @return
	 * @throws Exception
	 */
	public <T extends DocumentItem> T newItem(Class<T> cls,String... options) throws Exception;

	/**
	 * Requests a new page. After this call getCurrentLine() is expected to return 1.
	 * @throws Exception
	 */
	public void nextPage() throws Exception;
	
	/**
	 * Returns current line (of the page). The number for first line is 1. 
	 * @return
	 */
	public int getCurrentLine();
	
	/**
	 * Returns estimated available lines for current page. For non-paged implementations returns Integer.MAX_VALUE;
	 * @return
	 */
	public int getAvailableLines();
	
	/**
	 * Closes the document. 
	 * 
	 * @throws Exception
	 */
	public void close() throws Exception;


}