package org.simantics.document.linking.ge;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;

public class SourceReferenceOldTest  implements Test  {
	
	public SourceReferenceOldTest() {
	}
	
	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType == Variable.class;
	}
	
	@Override
	public boolean test(ReadGraph graph, Object content)
			throws DatabaseException {
		Variable variable = (Variable)content;
		Resource res = variable.getPossibleRepresents(graph);
		if (res == null)
			return false;
		DocumentLink sl = DocumentLink.getInstance(graph);
		DocumentResource doc = DocumentResource.getInstance(graph);
		if (graph.isInstanceOf(res, sl.Source)) {
			Resource ref = SourceLinkUtil.getReferredDocument(graph, res);
			if (ref != null)
				return graph.hasStatement(ref, doc.HasNewerVersion);
		}
		return false;
	}
	

}
