package org.simantics.document.linking.ge;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.ui.SimanticsUI;

public class RemoveSourceAction implements ActionFactory{
	
	
	@Override
	public Runnable create(Object target) {
		if (!(target instanceof Variable))
			return null;
		final Variable v = (Variable)target;
		

		return new Runnable() {
			
			@Override
			public void run() {
				SimanticsUI.getSession().asyncRequest(new WriteRequest() {
					
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
					    graph.markUndoPoint();
					    
						DocumentLink sl = DocumentLink.getInstance(graph);
						Resource t = v.getPossibleRepresents(graph);
						if (!graph.isInstanceOf(t, sl.Source))
							return;
						graph.deny(t);
						
					}
				});
				
			}
		};

		
	}

}
