/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.team.ui.handlers;

import java.io.File;
import java.nio.charset.Charset;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import org.simantics.db.Resource;
import org.simantics.db.ServerReference;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.team.Activator;
import org.simantics.team.internal.StagingLauncher;
import org.simantics.team.internal.StagingLauncher.Config;
import org.simantics.team.internal.StagingLauncher.StagingResult;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.handler.AbstractPreferenceHandler;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.dialogs.ShowError;

public class StageEditHandler extends AbstractPreferenceHandler {

    public StageEditHandler() {
        super(Activator.getDefault());
    }
    private void showError(String msg, Throwable t) {
        String title = "Staging failed!";
        ShowError.showError(title, msg, t);
    }
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        System.out.println("DEBUG: EditStageHandler");
        try {
            Session session = SimanticsUI.getSession();
            File wsFolder = new File(Platform.getInstanceLocation().getURL().getFile());
            File stFolder = new File(wsFolder, "staging");
            if (!stFolder.isDirectory())
                throw new DatabaseException("Folder must exist. path=" + stFolder.getAbsolutePath());
            show(session, stFolder);
        } catch (Throwable t) {
            showError("Staging failed:", t);
        } finally {
        }
        return null;
    }
    private void show(Session session, File stFolder) {
        final IProgressMonitor monitor = new NullProgressMonitor();
        try {
            monitor.beginTask("begin", 1300);
            LifecycleSupport lfs = session.getService(LifecycleSupport.class);
            ServerReference sref = lfs.getSessionReference().getServerReference();
//            SerialisationSupport ss = session.getService(SerialisationSupport.class);
            String randomAccessId = "target"; // String.valueOf(ss.getRandomAccessId(target));
            Resource targetLibrary = null;
            final Config config = new Config(session, targetLibrary, stFolder, null);
            StagingResult result = StagingLauncher.launch(config, sref.toString(), randomAccessId);
            if (result.getExitValue() != 0) {
                String msg = "";
                if (result.getLogFile().exists()) {
                    byte[] data = FileUtils.readFile(result.getLogFile());
                    msg = new String(data, Charset.defaultCharset());
                }
                if (msg.isEmpty() || msg.matches(" *"))
                    msg = "Staging crashed. Contact application support.";
                ShowError.showError("Staging failed, errorcode="+result.getExitValue(), msg, new Exception());
            }
            if (result.getMessageLog() != null) {
                MessageDialog.openError(PlatformUI.getWorkbench().getDisplay().getActiveShell(),
                        "Staging failed",
                        result.getMessageLog());
            }
            } catch (Exception e) {
                ErrorLogger.defaultLogError(e);
            } finally {
                monitor.done();
            }
    }
//    private String openInitDialog()
//    throws DatabaseException {
//        final Display display = PlatformUI.getWorkbench().getDisplay();
//        final StageInitDialog.Data data = new StageInitDialog.Data();
//        display.syncExec(new Runnable() {
//            @Override
//            public void run() {
//                data.comment = "Help!";
//                StageInitDialog d =  new StageInitDialog(display.getActiveShell(), data);
//                if (Dialog.OK != d.open())
//                    data.comment = null;
//            }});
//        return data.comment;
//    }
}
