/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.internal;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardLinkType;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.forward.IForwardMappingSchema;

public class MonotoneForwardMapping<Domain, Range>
implements IForwardMapping<Domain, Range> {
    IForwardMappingSchema<Domain, Range> schema;
    THashMap<Domain, Range> map = new THashMap();

    public MonotoneForwardMapping(IForwardMappingSchema<Domain, Range> schema) {
        this.schema = schema;
    }

    @Override
    public Set<Domain> getDomain() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Range get(Domain domainElement) {
        return (Range)this.map.get(domainElement);
    }

    @Override
    public Range map(ReadGraph graph, Domain domainElement) throws MappingException {
        Range result = this.get(domainElement);
        if (result == null) {
            IForwardLinkType<Domain, Range> linkType = this.schema.linkTypeOfDomainElement(graph, domainElement);
            Range rangeElement = linkType.createRangeElement(graph, domainElement);
            this.map.put(domainElement, rangeElement);
            linkType.createRange(graph, this, domainElement, rangeElement);
        }
        return result;
    }
}

