package org.simantics.modeling.tests.cases;

import org.simantics.db.testing.base.CommandList;
import org.simantics.db.testing.base.CommandListImpl;
import org.simantics.db.testing.base.CommandSequenceTest;
import org.simantics.db.testing.common.Command;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.tests.commands.CollectMemory;
import org.simantics.modeling.tests.commands.WaitActiveExperiment;
import org.simantics.modeling.tests.commands.WaitMapping;
import org.simantics.modeling.tests.commands.WriteHeapDump;

public abstract class ModelingCommandSequenceTest extends CommandSequenceTest {

	protected WaitActiveExperiment waitExperiment = new WaitActiveExperiment();
	protected WaitMapping waitMapping = new WaitMapping();
	protected CollectMemory collectMemory = new CollectMemory();
	protected WriteHeapDump heapDump = new WriteHeapDump(getClass().getSimpleName()+ ".hprof");

	protected DiagramResource DIA;

	@Override
	protected void initialize(CommandSequenceEnvironment environment) throws Exception {
		
		DIA = DiagramResource.getInstance(environment.getSession());
		
	}
	
	protected void createBeforeSequence(CommandList result) throws Exception {
	}

	protected void createAfterSequence(CommandList result) throws Exception {
	}

	protected void createSequence(CommandList result) throws Exception {
	}

	@Override
	protected Command[] beforeSequence(CommandSequenceEnvironment environment) throws Exception {
		CommandListImpl result = new CommandListImpl();
		createBeforeSequence(result);
		return result.toArray();
	}

	
	@Override
	protected Command[] newSequence() throws Exception {
		CommandListImpl result = new CommandListImpl();
		createSequence(result);
		return result.toArray();
	}


	@Override
	protected Command[] afterSequence(CommandSequenceEnvironment environment) throws Exception {
		CommandListImpl result = new CommandListImpl();
		createAfterSequence(result);
		return result.toArray();
	}
	
}
