/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl.proxy;

import java.awt.geom.Point2D;

import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Scale;

/**
 * @author Toni Kalajainen
 */
public class ProxyScale implements Scale {

    private static final long serialVersionUID = 7878265024571333532L;

    Scale orig;
    IProxyProvider provider;

    public ProxyScale(IProxyProvider provider, Scale orig) {
        this.provider = provider;
        this.orig = orig;
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        return orig.getFixedAspectRatio(provider.provide(e));
    }

    @Override
    public Point2D getMaximumScale(IElement e) {
        return orig.getMaximumScale(provider.provide(e));
    }

    @Override
    public Point2D getMinimumScale(IElement e) {
        return orig.getMinimumScale(provider.provide(e));
    }

    @Override
    public Point2D getScale(IElement e) {
        return orig.getScale(provider.provide(e));
    }

    @Override
    public void setScale(IElement e, Point2D newScale) {
        orig.setScale(provider.provide(e), newScale);
    }

}
