/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import java.awt.geom.AffineTransform;

import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Transform;

/**
 * @author Toni Kalajainen
 */
public class TransformImpl implements Transform {

    private static final long serialVersionUID = -3460399850873387149L;

    @Override
    public AffineTransform getTransform(IElement e) {
        AffineTransform at = e.getHint(ElementHints.KEY_TRANSFORM);
        return at;
    }

    @Override
    public void setTransform(IElement e, AffineTransform at) {
        e.setHint(ElementHints.KEY_TRANSFORM, at.clone());
    }

}
