/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler.impl;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.TextColor;

/**
 * 
 * @See {@link TextColor}
 * @author Toni Kalajainen
 */
public class TextColorImpl implements TextColor, LifeCycle {
	
    private static final long serialVersionUID = -3684758508037189899L;

    public static final TextColorImpl UNSET = new TextColorImpl(null);
    public static final TextColorImpl BLACK = new TextColorImpl(java.awt.Color.BLACK);
    public static final TextColorImpl WHITE = new TextColorImpl(java.awt.Color.WHITE);
    public static final TextColorImpl RED = new TextColorImpl(java.awt.Color.RED);
    public static final TextColorImpl BLUE = new TextColorImpl(java.awt.Color.BLUE);

    public synchronized static TextColorImpl handlerOf(java.awt.Color c)
    {
        return new TextColorImpl(c);
    }

    java.awt.Color defaultColor = java.awt.Color.BLACK;

    public TextColorImpl() {}
    public TextColorImpl(java.awt.Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    @Override
    public java.awt.Color getTextColor(IElement e) {		
        return e.getHint(ElementHints.KEY_TEXT_COLOR);
    }

    @Override
    public void setTextColor(IElement e, java.awt.Color c) {
        e.setHint(ElementHints.KEY_TEXT_COLOR, c);
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }
    @Override
    public void onElementCreated(IElement e) {
        if (defaultColor!=null)
            e.setHint(ElementHints.KEY_TEXT_COLOR, defaultColor);
    }
    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }
    @Override
    public void onElementDestroyed(IElement e) {
    }
}
