/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.element.handler;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;

/**
 * All ElementContributions that implement LifeCycle get
 * element create and destroy events.
 * 
 * @author Toni Kalajainen
 * 
 * @see Stub
 */
public interface LifeCycle extends ElementHandler {

    /**
     * a new element has been spawned to the world
     * @param e
     */
    void onElementCreated(IElement e);

    /**
     * Element has been destroyed from the world
     * @param e
     */
    void onElementDestroyed(IElement e);

    /**
     * Element has been activated (after creation, cloning or loading)
     * and added to a diagram.
     * 
     * @param d
     * @param e
     */
    void onElementActivated(IDiagram d, IElement e);

    /**
     * Element has been deactivated (disposed)
     * @param d
     * @param e
     */
    void onElementDeactivated(IDiagram d, IElement e);

    /**
     * A stub implementation for {@link LifeCycle} that does not do anything.
     * Extend this to avoid having to implement all methods.
     */
    public static class Stub implements LifeCycle {
        private static final long serialVersionUID = -569889719338663795L;

        @Override
        public void onElementActivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementCreated(IElement e) {
        }

        @Override
        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        @Override
        public void onElementDestroyed(IElement e) {
        }
    }

}
