/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.dnd;

import java.awt.geom.Rectangle2D;

import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

/**
 * @author Tuukka Lehtonen
 */
public class ElementClassDragItem implements IDragItem {

    private final ElementClass ec;
    private final HintContext        ctx = new HintContext();

    public ElementClassDragItem(ElementClass ec) {
        if (ec == null)
            throw new NullPointerException("null element class");
        this.ec = ec;
    }

    public ElementClass getElementClass() {
        return ec;
    }

    @Override
    public Rectangle2D getBounds() {
        Image i = ec.getSingleItem(StaticSymbol.class).getImage();
        return i.getBounds();
    }

    @Override
    public void paint(G2DParentNode parent) {
        Image i = ec.getSingleItem(StaticSymbol.class).getImage();
        i.init(parent);
    }

    @Override
    public IHintContext getHintContext() {
        return ctx;
    }

}