/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.g2d.diagram.handler;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;

/**
 * Keeps a map between an element and its back-end object (KEY_OBJECT)
 * 
 * @author Toni Kalajainen
 */
public interface DataElementMap extends DiagramHandler {

    /**
     * Get the element with given data (KEY_OBJECT)
     * 
     * @param data the data object to find an element for
     * @return element or null if no element has the data
     * 
     * @throws NullPointerException if diagram or data is <code>null</code>
     */
    IElement getElement(IDiagram d, Object data);

    /**
     * Get data related to an element
     * 
     * @param element the element to get a back-end data object for
     * @return data or null
     * 
     * @throws NullPointerException if diagram or element is <code>null</code>
     */
    Object getData(IDiagram d, IElement element);

}
