/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.service;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RelationInfo;
import org.simantics.db.Resource;
import org.simantics.db.procedure.AsyncContextMultiProcedure;
import org.simantics.db.procedure.AsyncContextProcedure;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncProcedure;

public interface DirectQuerySupport {

    void forEachDirectPersistentStatement(AsyncReadGraph graph, Resource subject, AsyncProcedure<DirectStatements> procedure);

    void forEachDirectStatement(AsyncReadGraph graph, Resource subject, AsyncProcedure<DirectStatements> procedure);
    void forEachDirectStatement(AsyncReadGraph graph, Resource subject, SyncProcedure<DirectStatements> procedure);
    void forEachDirectStatement(AsyncReadGraph graph, Resource subject, Procedure<DirectStatements> procedure);

    void forRelationInfo(AsyncReadGraph graph, Resource subject, AsyncProcedure<RelationInfo> procedure);
    void forRelationInfo(AsyncReadGraph graph, Resource subject, SyncProcedure<RelationInfo> procedure);
    void forRelationInfo(AsyncReadGraph graph, Resource subject, Procedure<RelationInfo> procedure);
    
    <T> void forPossibleType(AsyncReadGraph graph, Resource subject, AsyncProcedure<Resource> procedure);
    
    AsyncMultiProcedure<Resource> compileForEachObject(ReadGraph graph, Resource relation, AsyncMultiProcedure<Resource> user);
    <C> AsyncContextMultiProcedure<C, Resource> compileForEachObject(ReadGraph graph, Resource relation, AsyncContextMultiProcedure<C, Resource> user);
    <T> AsyncProcedure<T> compilePossibleRelatedValue(ReadGraph graph, Resource relation, AsyncProcedure<T> user);
    <C,T> AsyncContextProcedure<C,T> compilePossibleRelatedValue(ReadGraph graph, Resource relation, AsyncContextProcedure<C,T> user);
    
    void forEachObjectCompiled(AsyncReadGraph graph, Resource subject, AsyncMultiProcedure<Resource> procedure);
    <C> void forEachObjectCompiled(AsyncReadGraph graph, Resource subject, C context, AsyncContextMultiProcedure<C, Resource> procedure);
    <T> void forPossibleRelatedValueCompiled(AsyncReadGraph graph, Resource subject, AsyncProcedure<T> procedure);
    <C,T> void forPossibleRelatedValueCompiled(AsyncReadGraph graph, Resource subject, C context, AsyncContextProcedure<C,T> procedure);
    <C> void forPossibleDirectType(AsyncReadGraph graph, Resource subject, C context, AsyncContextProcedure<C,Resource> procedure);
    
}
