/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.exception;

public class ResourceNotFoundException extends AssumptionException {

    private static final long serialVersionUID = 1647209154838034514L;

    public ResourceNotFoundException(ResourceNotFoundException cause) {
        super(cause.getMessage());
    }

    public ResourceNotFoundException(long id) {
        super("Could not find [" + id + "].");
    }

    public ResourceNotFoundException(long id, Throwable cause) {
        super("Could not find [" + id + "].");
    }

    public ResourceNotFoundException(String uri) {
        super("Could not find <" + uri + ">.");
    }

    public ResourceNotFoundException(String uri, Throwable cause) {
        super("Could not find <" + uri + ">.", cause);
    }
    
    public DatabaseException newStack() {
    	return new ResourceNotFoundException(this);
    }

}
