/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.event;

import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;

/**
 * A listener added to a Session for receiving notifications for completed
 * write transactions.
 * 
 * @see GraphChangeEvent
 * @see Session
 */
public interface ChangeListener {

    /**
     * The listener gets a read lock along with the event (a {@link ReadGraph}
     * instance). This method should be implemented so that it never blocks.
     * 
     * The ChangeSet contained by the received event should only contain the
     * changes that intersect with the working set of the listener's Session.
     */
    void graphChanged(ChangeEvent e) throws DatabaseException;

}
