/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;


/**
 * A single session with a database.
 * Should be replaced with RequestProcessor
 *
 * A session is created for a particular database revision and also for a
 * particular time.
 *
 * @author Tuukka Lehtonen
 * @see SessionManager
 * @see Session
 */
public interface Session extends RequestProcessor {    
    /**
     * Marks the current database state or the beginning of the current ongoing
     * write transaction as an undo point. Calling this method several times
     * before or during the same write transaction has no effect.
     */
    void markUndoPoint();
}
