/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;

/**
 * 
 * For initiating requests in synchronous manner. The possible requests are
 * <ul>
 * <li>{@link ReadInterface} for computing a single result
 * <li>{@link WriteInterface} for making a modification into the database
 * </ul>
 * <p>
 * Some standard implementations of ReadInterface and WriteInterface include
 * <ul>
 * <li>{@link ResourceRead} which is identified by a single resource
 * <li>{@link ResourceRead2} which is identified by a pair of resources
 * <li>{@link UnaryRead} which is identifier by a single object
 * <li>{@link BinaryRead} which is identifier by a pair of objects
 * <li>{@link UniqueRead} which is unique (not equal to anything but itself)
 * <li>{@link ReadRequest} which does not report a result
 * <li>{@link WriteRequest} for writing
 * </ul>
 * <p>
 * The standard RequestProcessors are
 * <ul>
 * <li>{@link ReadGraph} for performing requests during other requests
 * <li>{@link Session} for initiating a transactions for performing requests
 * <li>{@link MergingGraphRequestProcessor} for merging several requests in a
 * single transaction
 * </ul>
 * 
 * Database services (see e.g. {@link Session}) are available from implemented
 * {@link ServiceLocator}. For an asynchronous counterpart with the same
 * functionality as RequestProcessor see {@link AsyncRequestProcessor}
 * 
 * <p>
 * <b>IMPORTANT:</b>A client invoking any of the <code>sync</code>
 * -methods in this interface must not assume that the request is performed
 * within the same thread that performed the <code>syncRequest</code>
 * invocation. This is an implementation-specific matter.
 * 
 * @version 1.5
 * @author Antti Villberg
 * @see ReadInterface
 * @see WriteInterface
 * @see ReadGraph
 * @see Session
 * @see MergingGraphRequestProcessor
 * @see AsyncRequestProcessor
 */
public interface RequestProcessor extends AsyncRequestProcessor, RequestProcessorSpecific {

    <T> T sync(ReadInterface<T> r) throws DatabaseException;
    <T> T sync(WriteInterface<T> r) throws DatabaseException;
    
}
