/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;


/**
 * An interface that services registered via {@link ServiceLocator} can
 * implement to signal the ServiceLocator implementation that they need to be
 * disposed during ServiceLocator disposal.
 * 
 * The {@link #dispose()} method may get called several times which it must be
 * able to handle properly which in most cases means just disposing once with
 * proper synchronization and ignoring any further dispose requests.
 * 
 * @author Tuukka Lehtonen
 */
public interface Disposable {

    void dispose();

}
