package org.simantics.db;

import org.simantics.databoard.Bindings;
import org.simantics.utils.Development;

public class DevelopmentKeys {

	final public static String PRINT = "Development.print";

	final public static String LOGGER_ECHO = trickToInitialize();
	
	final public static String WRITEGRAPH_DEBUG = "WriteGraph.debug";
	final public static String WRITEGRAPH_DEBUG_NAMES = "WriteGraph.debugNames";
	final public static String WRITEGRAPH_DEBUG_STACK = "WriteGraph.debugStack";

	final public static String WRITEGRAPH_EXCEPTION_STACKTRACES = "WriteGraph.exceptionStacktraces";
	
	final public static String WRITELOGGER_LOG = "WriteLogger.log";

	final public static String QUERYPROCESSOR_UPDATE = "QueryProcessor.update";

	final public static String QUERYPROCESSOR_PUT = "QueryProcessor.put";

	final public static String SESSION_LOG_WRITES = "Session.logWrites";

	final public static String READGRAPH_COUNT = "ReadGraph.count";

	final public static String CLUSTERTABLE_VALIDATE_ON_LOAD = "ClusterTable.validateOnLoad";

	public static void initialize() {

		if(Development.DEVELOPMENT) {

			Development.setProperty(DevelopmentKeys.PRINT, true, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.LOGGER_ECHO, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG, false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG_NAMES, false, Bindings.BOOLEAN);
			Development.setProperty(DevelopmentKeys.WRITEGRAPH_DEBUG_STACK, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.WRITEGRAPH_EXCEPTION_STACKTRACES, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.READGRAPH_COUNT, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.WRITELOGGER_LOG, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_UPDATE, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.QUERYPROCESSOR_PUT, false, Bindings.BOOLEAN);

			Development.setProperty(DevelopmentKeys.SESSION_LOG_WRITES, false, Bindings.BOOLEAN);
			
			Development.setProperty(DevelopmentKeys.CLUSTERTABLE_VALIDATE_ON_LOAD, false, Bindings.BOOLEAN);
			
			

		}

	}
	// This enables to call initialize even if bundle activator is not yet called.
	// This happens when calling from headless junit4 plugin driver and ProCoreServer process does not start.  
	private static String trickToInitialize() {
        return "Logger.echo"; 
	}
	static {
        initialize();
	}
}
